/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections;

import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.ComparisonFunctions;
import com.github.detentor.codex.collections.Convertable;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.Function2;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.monads.Option;
import com.github.detentor.codex.product.Tuple2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractSharpCollection<T, U extends SharpCollection<T>>
implements SharpCollection<T>,
Convertable<T>,
ComparisonFunctions<T> {
    private static final String UNCHECKED = "unchecked";

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public boolean contains(T element) {
        for (Object ele : this) {
            if (!ele.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(SharpCollection<T> col) {
        for (T ele : col) {
            if (this.contains(ele)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T head() {
        this.ensureNotEmpty("head foi chamado para uma cole\u00e7\u00e3o vazia");
        return this.iterator().next();
    }

    @Override
    public Option<T> headOption() {
        return this.isEmpty() ? Option.empty() : Option.from(this.head());
    }

    @Override
    public T last() {
        return this.takeRight(1).head();
    }

    @Override
    public Option<T> lastOption() {
        return this.isEmpty() ? Option.empty() : Option.from(this.last());
    }

    public U tail() {
        this.ensureNotEmpty("tail foi chamado para uma cole\u00e7\u00e3o vazia");
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        ite.next();
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)colecaoRetorno.result();
    }

    public U take(Integer num) {
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        int count = 0;
        while (count++ < num && ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)colecaoRetorno.result();
    }

    public U takeRight(Integer num) {
        int eleToSkip = Math.max(this.size() - num, 0);
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        for (int curCount = 0; ite.hasNext() && curCount < eleToSkip; ++curCount) {
            ite.next();
        }
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)colecaoRetorno.result();
    }

    public U drop(Integer num) {
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        int count = 0;
        while (count++ < num && ite.hasNext()) {
            ite.next();
        }
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)colecaoRetorno.result();
    }

    public U dropRight(Integer num) {
        int toAdd = Math.max(0, this.size() - num);
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        int count = 0;
        while (ite.hasNext() && count++ < toAdd) {
            colecaoRetorno.add(ite.next());
        }
        return (U)colecaoRetorno.result();
    }

    @Override
    public Tuple2<? extends U, ? extends U> splitAt(Integer num) {
        Builder colRetorno1 = this.builder();
        Iterator ite = this.iterator();
        int count = 0;
        while (count++ < num && ite.hasNext()) {
            colRetorno1.add(ite.next());
        }
        Builder colRetorno2 = this.builder();
        while (ite.hasNext()) {
            colRetorno2.add(ite.next());
        }
        return Tuple2.from(colRetorno1.result(), colRetorno2.result());
    }

    @Override
    public SharpCollection<? extends U> grouped(Integer size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size deve ser maior do que zero");
        }
        Builder colOfCols = this.builder();
        Iterator ite = this.iterator();
        int count = 0;
        Builder curColecao = this.builder();
        while (ite.hasNext()) {
            curColecao.add(ite.next());
            if (++count != size) continue;
            colOfCols.add(curColecao.result());
            curColecao = this.builder();
            count = 0;
        }
        if (count != 0) {
            colOfCols.add(curColecao.result());
        }
        return colOfCols.result();
    }

    @Override
    public String mkString() {
        return this.mkString("", "", "");
    }

    @Override
    public String mkString(String separator) {
        return this.mkString("", separator, "");
    }

    @Override
    public String mkString(String start, String separator, String end) {
        StringBuilder sBuilder = new StringBuilder();
        Iterator ite = this.iterator();
        sBuilder.append(start);
        while (ite.hasNext()) {
            sBuilder.append(ite.next());
            if (!ite.hasNext()) continue;
            sBuilder.append(separator);
        }
        sBuilder.append(end);
        return sBuilder.toString();
    }

    @Override
    public String mkString(String start, String separator, String end, Function1<? super T, String> mapFunction) {
        StringBuilder sBuilder = new StringBuilder();
        Iterator ite = this.iterator();
        sBuilder.append(start);
        while (ite.hasNext()) {
            sBuilder.append(mapFunction.apply(ite.next()));
            if (!ite.hasNext()) continue;
            sBuilder.append(separator);
        }
        sBuilder.append(end);
        return sBuilder.toString();
    }

    public U dropWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        while (ite.hasNext()) {
            Object curEle = ite.next();
            if (pred.apply(curEle).booleanValue()) continue;
            colecaoRetorno.add(curEle);
            break;
        }
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)colecaoRetorno.result();
    }

    public U dropRightWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        Iterator ite = this.iterator();
        Builder tempCollection = this.builder();
        while (ite.hasNext()) {
            Object curEle = ite.next();
            if (pred.apply(curEle).booleanValue()) {
                tempCollection.add(curEle);
                continue;
            }
            for (Object ele : tempCollection.result()) {
                colecaoRetorno.add(ele);
            }
            colecaoRetorno.add(curEle);
            tempCollection = this.builder();
        }
        return (U)colecaoRetorno.result();
    }

    public U takeWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        for (Object curEle : this) {
            if (!pred.apply(curEle).booleanValue()) break;
            colecaoRetorno.add(curEle);
        }
        return (U)colecaoRetorno.result();
    }

    public U takeRightWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        for (Object curEle : this) {
            if (pred.apply(curEle).booleanValue()) {
                colecaoRetorno.add(curEle);
                continue;
            }
            colecaoRetorno = this.builder();
        }
        return (U)colecaoRetorno.result();
    }

    @Override
    public Option<T> find(Function1<? super T, Boolean> pred) {
        for (Object curEle : this) {
            if (!pred.apply(curEle).booleanValue()) continue;
            return Option.from(curEle);
        }
        return Option.empty();
    }

    public U filter(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        for (Object ele : this) {
            if (!pred.apply(ele).booleanValue()) continue;
            colecaoRetorno.add(ele);
        }
        return (U)colecaoRetorno.result();
    }

    @Override
    public Tuple2<? extends SharpCollection<T>, ? extends SharpCollection<T>> partition(Function1<? super T, Boolean> pred) {
        Builder predTrue = this.builder();
        Builder predFalse = this.builder();
        for (Object ele : this) {
            if (pred.apply(ele).booleanValue()) {
                predTrue.add(ele);
                continue;
            }
            predFalse.add(ele);
        }
        return Tuple2.from(predTrue.result(), predFalse.result());
    }

    @Override
    public boolean exists(Function1<? super T, Boolean> pred) {
        for (Object ele : this) {
            if (!pred.apply(ele).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean forall(Function1<? super T, Boolean> pred) {
        for (Object ele : this) {
            if (pred.apply(ele).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer count(Function1<? super T, Boolean> pred) {
        int numElementos = 0;
        for (Object ele : this) {
            if (!pred.apply(ele).booleanValue()) continue;
            ++numElementos;
        }
        return numElementos;
    }

    @Override
    public <B> B foldLeft(B startValue, Function2<B, ? super T, B> function) {
        B accumulator = startValue;
        for (Object ele : this) {
            accumulator = function.apply(accumulator, ele);
        }
        return accumulator;
    }

    @Override
    public <B> SharpCollection<B> map(Function1<? super T, B> function) {
        Builder colecaoRetorno = this.builder();
        for (Object ele : this) {
            colecaoRetorno.add(function.apply(ele));
        }
        return colecaoRetorno.result();
    }

    @Override
    public <B> SharpCollection<B> collect(PartialFunction1<? super T, B> pFunction) {
        Builder colecaoRetorno = this.builder();
        for (Object ele : this) {
            if (!pFunction.isDefinedAt(ele)) continue;
            colecaoRetorno.add(pFunction.apply(ele));
        }
        return colecaoRetorno.result();
    }

    @Override
    public <B> SharpCollection<B> flatMap(Function1<? super T, ? extends SharpCollection<B>> function) {
        Builder colecaoRetorno = this.builder();
        for (Object ele : this) {
            for (B mappedEle : function.apply(ele)) {
                colecaoRetorno.add(mappedEle);
            }
        }
        return colecaoRetorno.result();
    }

    @Override
    public T maxWith(Comparator<? super T> comparator) {
        this.ensureNotEmpty();
        Iterator ite = this.iterator();
        Object maxValue = ite.next();
        while (ite.hasNext()) {
            Object curEle = ite.next();
            if (comparator.compare(curEle, maxValue) <= 0) continue;
            maxValue = curEle;
        }
        return maxValue;
    }

    @Override
    public T minWith(Comparator<? super T> comparator) {
        this.ensureNotEmpty();
        Iterator ite = this.iterator();
        Object minValue = ite.next();
        while (ite.hasNext()) {
            Object curEle = ite.next();
            if (comparator.compare(curEle, minValue) >= 0) continue;
            minValue = curEle;
        }
        return minValue;
    }

    @Override
    public T min() {
        return (T)this.minWith(new DefaultComparator());
    }

    @Override
    public T max() {
        return (T)this.maxWith(new DefaultComparator());
    }

    @Override
    public Option<T> minOption() {
        return this.isEmpty() ? Option.empty() : Option.from(this.min());
    }

    @Override
    public Option<T> maxOption() {
        return this.isEmpty() ? Option.empty() : Option.from(this.max());
    }

    public U intersect(SharpCollection<T> withCollection) {
        Builder colecaoRetorno = this.builder();
        for (Object ele : this) {
            if (!withCollection.contains(ele)) continue;
            colecaoRetorno.add(ele);
        }
        return (U)colecaoRetorno.result();
    }

    public U distinct() {
        Builder colecaoRetorno = this.builder();
        int count = -1;
        for (Object ele : this) {
            if (this.take(++count).contains(ele)) continue;
            colecaoRetorno.add(ele);
        }
        return (U)colecaoRetorno.result();
    }

    @Override
    public SharpCollection<Tuple2<T, Integer>> zipWithIndex() {
        Builder colecaoRetorno = this.builder();
        int curIndex = -1;
        for (Object ele : this) {
            colecaoRetorno.add(Tuple2.from(ele, ++curIndex));
        }
        return colecaoRetorno.result();
    }

    @Override
    public List<T> toList() {
        return this.toList(new ArrayListBuilder());
    }

    @Override
    public List<T> toList(Builder<T, List<T>> builder) {
        for (Object ele : this) {
            builder.add(ele);
        }
        return builder.result();
    }

    @Override
    public Set<T> toSet() {
        return this.toSet(new HashSetBuilder());
    }

    @Override
    public Set<T> toSet(Builder<T, Set<T>> builder) {
        for (Object ele : this) {
            builder.add(ele);
        }
        return builder.result();
    }

    protected void ensureNotEmpty(String message) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void ensureNotEmpty() {
        this.ensureNotEmpty("M\u00e9todo n\u00e3o definido para cole\u00e7\u00f5es vazias");
    }

    private static final class ArrayListBuilder<E>
    implements Builder<E, List<E>> {
        private final List<E> list = new ArrayList();

        private ArrayListBuilder() {
        }

        @Override
        public void add(E element) {
            this.list.add(element);
        }

        @Override
        public List<E> result() {
            return this.list;
        }
    }

    private static final class HashSetBuilder<E>
    implements Builder<E, Set<E>> {
        private final Set<E> backingSet = new HashSet();

        private HashSetBuilder() {
        }

        @Override
        public void add(E element) {
            this.backingSet.add(element);
        }

        @Override
        public Set<E> result() {
            return this.backingSet;
        }
    }

    protected static final class DefaultComparator<A extends Comparable<A>>
    implements Comparator<A>,
    Serializable {
        private static final long serialVersionUID = 6163897449143010763L;

        @Override
        public int compare(A ob1, A ob2) {
            return ob1.compareTo(ob2);
        }
    }
}

