/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.immutable;

import com.github.detentor.codex.collections.AbstractLinearSeq;
import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.LinearSeq;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.collections.immutable.ListSharp;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.Function2;
import com.github.detentor.codex.function.Functions;
import com.github.detentor.codex.function.PartialFunction0;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.function.arrow.impl.StatePartialArrow0;
import com.github.detentor.codex.monads.Option;
import com.github.detentor.codex.product.Tuple2;
import com.github.detentor.codex.util.RichIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LazyList<T>
extends AbstractLinearSeq<T, LazyList<T>> {
    protected Object head;
    protected LazyList<T> tail;
    public static final LazyList<Object> Nil = new LazyList<Object>(null, null);

    protected LazyList(T theHead, LazyList<T> theTail) {
        this.head = theHead;
        this.tail = theTail;
    }

    public static <A> LazyList<A> empty() {
        return Nil;
    }

    public static <T> LazyList<T> from(T valor) {
        return new LazyList<Object>(valor, Nil);
    }

    public static <T> LazyList<T> from(T ... valores) {
        LinkedListBuilder<T> builder = new LinkedListBuilder<T>();
        for (int i = 0; i < valores.length; ++i) {
            builder.add(valores[i]);
        }
        return builder.result();
    }

    public static <T> LazyList<T> from(Iterable<T> theIterable) {
        return new LazyListI<T>(theIterable.iterator());
    }

    public static <T> LazyList<T> unfold(PartialFunction0<T> genFunction) {
        return new UnfoldedList<T>(genFunction);
    }

    @Override
    public boolean isEmpty() {
        return this.head() == null && this.tail() == null;
    }

    @Override
    public T head() {
        return (T)this.head;
    }

    @Override
    public LazyList<T> tail() {
        return this.tail;
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        return new LinkedListBuilder();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("[" + this.head());
        LazyList<T> curTail = this.tail;
        while (!(curTail.head instanceof Uninitialized) && curTail.notEmpty()) {
            sBuilder.append(", " + curTail.head());
            curTail = curTail.tail;
        }
        if (!curTail.isEmpty()) {
            sBuilder.append(", ?");
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public <B> LazyList<B> map(Function1<? super T, B> function) {
        return new MapMonadic<T, B>(this.iterator(), function);
    }

    @Override
    public LazyList<T> filter(Function1<? super T, Boolean> pred) {
        return new FilterMonadic<T>(this.iterator(), pred);
    }

    @Override
    public <B> LazyList<B> collect(PartialFunction1<? super T, B> pFunction) {
        return new FMapMonadic<T, B>(this.iterator(), pFunction);
    }

    @Override
    public LazyList<T> drop(Integer num) {
        return LazyList.unfold(new StatePartialArrow0<Tuple2<Iterator<T>, Integer>, T>(Tuple2.from(this.iterator(), num)){

            @Override
            public T apply() {
                return ((Iterator)((Tuple2)this.state).getVal1()).next();
            }

            private Tuple2<Iterator<T>, Integer> consumeIterator() {
                int curCount = (Integer)((Tuple2)this.state).getVal2();
                while (curCount-- > 0 && ((Iterator)((Tuple2)this.state).getVal1()).hasNext()) {
                    ((Iterator)((Tuple2)this.state).getVal1()).next();
                }
                ((Tuple2)this.state).setVal2(curCount);
                return (Tuple2)this.state;
            }

            @Override
            public boolean isDefined() {
                return this.consumeIterator().getVal1().hasNext();
            }
        });
    }

    @Override
    public LazyList<T> take(Integer num) {
        return LazyList.unfold(new StatePartialArrow0<Tuple2<Iterator<T>, Integer>, T>(Tuple2.from(this.iterator(), num)){

            @Override
            public T apply() {
                ((Tuple2)this.state).setVal2((Integer)((Tuple2)this.state).getVal2() - 1);
                return ((Iterator)((Tuple2)this.state).getVal1()).next();
            }

            @Override
            public boolean isDefined() {
                return (Integer)((Tuple2)this.state).getVal2() > 0 && ((Iterator)((Tuple2)this.state).getVal1()).hasNext();
            }
        });
    }

    @Override
    public LazyList<T> dropWhile(final Function1<? super T, Boolean> pred) {
        return LazyList.unfold(new StatePartialArrow0<Tuple2<RichIterator<T>, Boolean>, T>(Tuple2.from(RichIterator.from(this.iterator()), true)){

            @Override
            public T apply() {
                return ((RichIterator)((Tuple2)this.state).getVal1()).next();
            }

            private Iterator<T> consumeIterator() {
                while (((Boolean)((Tuple2)this.state).getVal2()).booleanValue() && ((RichIterator)((Tuple2)this.state).getVal1()).hasNext() && ((Boolean)pred.apply(((RichIterator)((Tuple2)this.state).getVal1()).peekNext().get())).booleanValue()) {
                    ((RichIterator)((Tuple2)this.state).getVal1()).next();
                }
                ((Tuple2)this.state).setVal2(false);
                return (Iterator)((Tuple2)this.state).getVal1();
            }

            @Override
            public boolean isDefined() {
                return this.consumeIterator().hasNext();
            }
        });
    }

    @Override
    public LazyList<T> takeWhile(final Function1<? super T, Boolean> pred) {
        return LazyList.unfold(new StatePartialArrow0<Tuple2<RichIterator<T>, Boolean>, T>(Tuple2.from(RichIterator.from(this.iterator()), true)){

            @Override
            public T apply() {
                return ((RichIterator)((Tuple2)this.state).getVal1()).next();
            }

            @Override
            public boolean isDefined() {
                if (((Boolean)((Tuple2)this.state).getVal2()).booleanValue()) {
                    ((Tuple2)this.state).setVal2(((RichIterator)((Tuple2)this.state).getVal1()).peekNext().notEmpty() && (Boolean)pred.apply(((RichIterator)((Tuple2)this.state).getVal1()).peekNext().get()) != false);
                }
                return (Boolean)((Tuple2)this.state).getVal2();
            }
        });
    }

    @Override
    public Tuple2<LazyList<T>, LazyList<T>> partition(Function1<? super T, Boolean> pred) {
        return Tuple2.from(this.filter((Function1)pred), this.filter(Functions.not(pred)));
    }

    @Override
    public LazyList<T> intersect(final SharpCollection<T> withCollection) {
        return LazyList.unfold(new StatePartialArrow0<Iterator<T>, T>(this.iterator()){
            private final Object UNINITIALIZED;
            private Object nextElement;
            {
                super(x0);
                this.nextElement = this.UNINITIALIZED = new Uninitialized(null);
            }

            @Override
            public T apply() {
                Object toReturn = this.nextElement;
                this.nextElement = this.UNINITIALIZED;
                return toReturn;
            }

            private Object consumeIterator() {
                if (this.nextElement instanceof Uninitialized) {
                    Object curEle = null;
                    while (((Iterator)this.state).hasNext()) {
                        Object e = ((Iterator)this.state).next();
                        curEle = e;
                        if (!withCollection.contains(e)) continue;
                        this.nextElement = curEle;
                        break;
                    }
                }
                return this.nextElement;
            }

            @Override
            public boolean isDefined() {
                return !(this.consumeIterator() instanceof Uninitialized);
            }
        });
    }

    @Override
    public LazyList<T> distinct() {
        UnfoldedList uList = new UnfoldedList(null);
        StatePartialArrow0 function = new StatePartialArrow0<Tuple2<Iterator<T>, LazyList<T>>, T>(Tuple2.from(this.iterator(), uList)){
            private final Object UNINITIALIZED;
            private Object nextElement;
            {
                this.nextElement = this.UNINITIALIZED = new Uninitialized(null);
            }

            @Override
            public T apply() {
                Object toReturn = this.nextElement;
                this.nextElement = this.UNINITIALIZED;
                return toReturn;
            }

            private Object consumeIterator() {
                if (this.nextElement instanceof Uninitialized) {
                    Object curEle = null;
                    while (((Iterator)((Tuple2)this.state).getVal1()).hasNext()) {
                        Object e = ((Iterator)((Tuple2)this.state).getVal1()).next();
                        curEle = e;
                        if (this.contains((LazyList)((Tuple2)this.state).getVal2(), e)) continue;
                        this.nextElement = curEle;
                        break;
                    }
                }
                return this.nextElement;
            }

            private boolean contains(LazyList<T> theList, T element) {
                LazyList curList = theList;
                while (!(curList.head instanceof Uninitialized)) {
                    if (curList.head.equals(element)) {
                        return true;
                    }
                    curList = curList.tail;
                }
                return false;
            }

            @Override
            public boolean isDefined() {
                return !(this.consumeIterator() instanceof Uninitialized);
            }
        };
        uList.head = new Uninitialized(function);
        return uList;
    }

    @Override
    public <B> LazyList<B> flatMap(final Function1<? super T, ? extends SharpCollection<B>> function) {
        return LazyList.unfold(new StatePartialArrow0<Iterator<T>, B>(this.iterator()){
            private final Object UNINITIALIZED;
            private Object nextElement;
            {
                super(x0);
                this.nextElement = this.UNINITIALIZED = new Uninitialized(null);
            }

            @Override
            public B apply() {
                Object toReturn = ((Iterator)this.nextElement).next();
                if (!((Iterator)this.nextElement).hasNext()) {
                    this.nextElement = this.UNINITIALIZED;
                }
                return toReturn;
            }

            private Object consumeIterator() {
                if (this.nextElement instanceof Uninitialized) {
                    SharpCollection curEle = null;
                    while (((Iterator)this.state).hasNext()) {
                        curEle = (SharpCollection)function.apply(((Iterator)this.state).next());
                        if (!curEle.notEmpty()) continue;
                        this.nextElement = curEle.iterator();
                        break;
                    }
                }
                return this.nextElement;
            }

            @Override
            public boolean isDefined() {
                return !(this.consumeIterator() instanceof Uninitialized);
            }
        });
    }

    @Override
    public Tuple2<LazyList<T>, LazyList<T>> splitAt(Integer num) {
        return Tuple2.from(this.drop(num), this.take(num));
    }

    @Override
    public LazyList<LazyList<T>> grouped(final Integer size) {
        return LazyList.unfold(new StatePartialArrow0<Iterator<T>, LazyList<T>>(this.iterator()){

            @Override
            public LazyList<T> apply() {
                LazyList<Object> curEle;
                LazyList<Object> first = curEle = new LazyList<Object>(null, null);
                int count = 0;
                while (count++ < size && ((Iterator)this.state).hasNext()) {
                    curEle.head = ((Iterator)this.state).next();
                    curEle.tail = new LazyList<Object>(null, null);
                    curEle = curEle.tail;
                }
                return first;
            }

            @Override
            public boolean isDefined() {
                return ((Iterator)this.state).hasNext();
            }
        });
    }

    public <B> LazyList<B> scanLeft(B startValue, final Function2<B, T, B> func) {
        return LazyList.unfold(new StatePartialArrow0<Tuple2<Iterator<T>, B>, B>(Tuple2.from(this.iterator(), startValue)){

            @Override
            public B apply() {
                Object retorno = func.apply(((Tuple2)this.state).getVal2(), ((Iterator)((Tuple2)this.state).getVal1()).next());
                ((Tuple2)this.state).setVal2(retorno);
                return retorno;
            }

            @Override
            public boolean isDefined() {
                return ((Iterator)((Tuple2)this.state).getVal1()).hasNext();
            }
        });
    }

    @Override
    public LazyList<Tuple2<T, Integer>> zipWithIndex() {
        return LazyList.unfold(new StatePartialArrow0<Tuple2<Iterator<T>, Integer>, Tuple2<T, Integer>>(Tuple2.from(this.iterator(), 0)){

            @Override
            public Tuple2<T, Integer> apply() {
                Integer curIndex = (Integer)((Tuple2)this.state).getVal2();
                ((Tuple2)this.state).setVal2(curIndex + 1);
                return Tuple2.from(((Iterator)((Tuple2)this.state).getVal1()).next(), curIndex);
            }

            @Override
            public boolean isDefined() {
                return ((Iterator)((Tuple2)this.state).getVal1()).hasNext();
            }
        });
    }

    public LazyList<T> force() {
        if (this.isEmpty()) {
            return this;
        }
        LinearSeq curTail = this.tail();
        while (((AbstractSharpCollection)((Object)curTail)).notEmpty()) {
            curTail = ((LazyList)curTail).tail();
        }
        return this;
    }

    @Override
    public T last() {
        return super.last();
    }

    @Override
    public LazyList<T> takeRight(Integer num) {
        return (LazyList)super.takeRight(num);
    }

    @Override
    public LazyList<T> dropRight(Integer num) {
        return (LazyList)super.dropRight(num);
    }

    @Override
    public LazyList<T> dropRightWhile(Function1<? super T, Boolean> pred) {
        return (LazyList)super.dropRightWhile((Function1)pred);
    }

    @Override
    public LazyList<T> takeRightWhile(Function1<? super T, Boolean> pred) {
        return (LazyList)super.takeRightWhile((Function1)pred);
    }

    @Override
    public Option<T> lastOption() {
        return super.lastOption();
    }

    @Override
    public String mkString() {
        return super.mkString();
    }

    @Override
    public String mkString(String separator) {
        return super.mkString(separator);
    }

    @Override
    public String mkString(String start, String separator, String end) {
        return super.mkString(start, separator, end);
    }

    @Override
    public String mkString(String start, String separator, String end, Function1<? super T, String> mapFunction) {
        return super.mkString(start, separator, end, mapFunction);
    }

    @Override
    public T maxWith(Comparator<? super T> comparator) {
        return super.maxWith(comparator);
    }

    @Override
    public T minWith(Comparator<? super T> comparator) {
        return super.minWith(comparator);
    }

    @Override
    public T min() {
        return super.min();
    }

    @Override
    public T max() {
        return super.max();
    }

    @Override
    public Option<T> minOption() {
        return super.minOption();
    }

    @Override
    public Option<T> maxOption() {
        return super.maxOption();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public List<T> toList() {
        return super.toList();
    }

    @Override
    public List<T> toList(Builder<T, List<T>> builder) {
        return super.toList(builder);
    }

    @Override
    public Set<T> toSet() {
        return super.toSet();
    }

    @Override
    public Set<T> toSet(Builder<T, Set<T>> builder) {
        return super.toSet(builder);
    }

    @Override
    public LazyList<T> sorted() {
        return this.sorted((Comparator)new AbstractSharpCollection.DefaultComparator());
    }

    @Override
    public LazyList<T> sorted(Comparator<? super T> comparator) {
        return LazyList.from(ListSharp.from(this).sorted((Comparator)comparator));
    }

    private static final class FMapMonadic<T, A>
    extends LazyMonadic<A> {
        protected FMapMonadic(Iterator<T> theIterator, PartialFunction1<? super T, A> thePartialFunction) {
            super(Tuple2.from(theIterator, thePartialFunction));
        }

        @Override
        protected void extractValues() {
            Tuple2 tuple = (Tuple2)((Uninitialized)this.head).keptObject;
            while (((Iterator)tuple.getVal1()).hasNext()) {
                Object curEle = ((Iterator)tuple.getVal1()).next();
                if (!((PartialFunction1)tuple.getVal2()).isDefinedAt(curEle)) continue;
                this.head = ((PartialFunction1)tuple.getVal2()).apply(curEle);
                this.tail = new FMapMonadic<T, A>((Iterator)tuple.getVal1(), (PartialFunction1)tuple.getVal2());
                return;
            }
            this.head = null;
            this.tail = null;
        }
    }

    private static final class FilterMonadic<T>
    extends LazyMonadic<T> {
        protected FilterMonadic(Iterator<T> theIterator, Function1<? super T, Boolean> theFilterFunction) {
            super(Tuple2.from(theIterator, theFilterFunction));
        }

        @Override
        protected void extractValues() {
            Tuple2 tuple = (Tuple2)((Uninitialized)this.head).keptObject;
            while (((Iterator)tuple.getVal1()).hasNext()) {
                Object curEle = ((Iterator)tuple.getVal1()).next();
                if (!((Boolean)((Function1)tuple.getVal2()).apply(curEle)).booleanValue()) continue;
                this.head = curEle;
                this.tail = new FilterMonadic<T>((Iterator)tuple.getVal1(), (Function1)tuple.getVal2());
                return;
            }
            this.head = null;
            this.tail = null;
        }
    }

    private static final class MapMonadic<T, B>
    extends LazyMonadic<B> {
        protected MapMonadic(Iterator<T> theIterator, Function1<? super T, B> theMappingFunction) {
            super(Tuple2.from(theIterator, theMappingFunction));
        }

        @Override
        protected void extractValues() {
            Tuple2 tuple = (Tuple2)((Uninitialized)this.head).keptObject;
            if (((Iterator)tuple.getVal1()).hasNext()) {
                this.head = ((Function1)tuple.getVal2()).apply(((Iterator)tuple.getVal1()).next());
                this.tail = new MapMonadic<T, B>((Iterator)tuple.getVal1(), (Function1)tuple.getVal2());
            } else {
                this.head = null;
                this.tail = null;
            }
        }
    }

    private static class LazyListI<T>
    extends LazyMonadic<T> {
        protected LazyListI(Iterator<T> theIterator) {
            super(theIterator);
        }

        @Override
        protected void extractValues() {
            Iterator iterator = (Iterator)((Uninitialized)this.head).keptObject;
            if (iterator.hasNext()) {
                this.head = iterator.next();
                this.tail = new LazyListI<T>(iterator);
            } else {
                this.head = null;
                this.tail = null;
            }
        }
    }

    private static final class UnfoldedList<T>
    extends LazyMonadic<T> {
        protected UnfoldedList(PartialFunction0<T> theGenFunction) {
            super(theGenFunction);
        }

        @Override
        protected void extractValues() {
            PartialFunction0 genFunction = (PartialFunction0)((Uninitialized)this.head).keptObject;
            if (genFunction.isDefined()) {
                this.head = genFunction.apply();
                this.tail = new UnfoldedList<T>(genFunction);
            } else {
                this.head = null;
                this.tail = null;
            }
        }
    }

    private static abstract class LazyMonadic<T>
    extends LazyList<T> {
        protected LazyMonadic(Object valueToKeep) {
            super(new Uninitialized(valueToKeep), null);
        }

        protected abstract void extractValues();

        @Override
        public boolean isEmpty() {
            return this.head() == null && this.tail == null;
        }

        @Override
        public T head() {
            if (this.head instanceof Uninitialized) {
                this.extractValues();
            }
            return (T)this.head;
        }

        @Override
        public LazyList<T> tail() {
            this.ensureNotEmpty("tail foi chamado para uma cole\u00e7\u00e3o vazia");
            return this.tail;
        }
    }

    private static final class LinkedListBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private LazyList<E> list = LazyList.empty();
        private LazyList<E> last;

        private LinkedListBuilder() {
        }

        @Override
        public void add(E element) {
            if (this.list.isEmpty()) {
                this.list = LazyList.from(element);
                this.last = this.list;
            } else {
                LazyList<E> novoEle = LazyList.from(element);
                this.last.tail = novoEle;
                this.last = novoEle;
            }
        }

        @Override
        public LazyList<E> result() {
            return this.list;
        }
    }

    private static final class Uninitialized {
        protected final Object keptObject;

        private Uninitialized(Object keptObject) {
            this.keptObject = keptObject;
        }
    }
}

