/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.immutable;

import com.github.detentor.codex.collections.AbstractIndexedSeq;
import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.collections.mutable.MapSharp;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.product.Tuple2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ListSharp<T>
extends AbstractIndexedSeq<T, ListSharp<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int startIndex;
    private final int theSize;
    private final Object[] data;
    private static final ListSharp<Object> EMPTY_LIST = new ListSharp();

    protected ListSharp() {
        this.startIndex = 0;
        this.theSize = 0;
        this.data = new Object[0];
    }

    protected ListSharp(Object[] theData) {
        this(theData, 0, theData.length);
    }

    protected ListSharp(Object[] theData, int theStart, int theEnd) {
        this.startIndex = theStart;
        this.theSize = theEnd - theStart;
        this.data = theData;
    }

    protected ListSharp(ListSharp<T> prevList, int theStart, int theEnd) {
        this.startIndex = prevList.startIndex + theStart;
        this.theSize = theEnd - theStart;
        this.data = prevList.data;
    }

    public static <A> ListSharp<A> empty() {
        return EMPTY_LIST;
    }

    public static <T> ListSharp<T> from(Iterable<T> theIterable) {
        ArrayList<T> listaRetorno = new ArrayList<T>();
        for (T ele : theIterable) {
            listaRetorno.add(ele);
        }
        return new ListSharp<T>(listaRetorno.toArray());
    }

    public static <T> ListSharp<T> from(T ... valores) {
        return new ListSharp<T>(Arrays.copyOf(valores, valores.length));
    }

    @Override
    public int size() {
        return this.theSize;
    }

    @Override
    public ListSharp<T> subsequence(int startIndex, int endIndex) {
        return new ListSharp<T>(this, Math.max(startIndex, 0), Math.min(endIndex, this.size()));
    }

    @Override
    public T apply(Integer param) {
        return (T)this.data[this.startIndex + param];
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        return new ImArrayBuilder();
    }

    @Override
    public <B> ListSharp<B> map(final Function1<? super T, B> function) {
        return new ListSharp<B>(this.data, this.startIndex, this.startIndex + this.size()){
            private static final long serialVersionUID = 1L;

            @Override
            public B apply(Integer param) {
                return function.apply(ListSharp.this.apply(param));
            }
        };
    }

    @Override
    public <B> ListSharp<B> collect(PartialFunction1<? super T, B> pFunction) {
        return (ListSharp)super.collect(pFunction);
    }

    @Override
    public <B> ListSharp<B> flatMap(Function1<? super T, ? extends SharpCollection<B>> function) {
        return (ListSharp)super.flatMap(function);
    }

    @Override
    public ListSharp<Tuple2<T, Integer>> zipWithIndex() {
        return (ListSharp)super.zipWithIndex();
    }

    public String toString() {
        return this.mkString("[", ", ", "]");
    }

    @Override
    public ListSharp<T> reverse() {
        return new ListSharp<T>(this, this.startIndex, this.startIndex + this.size()){
            private static final long serialVersionUID = 1L;

            @Override
            public T apply(Integer param) {
                return super.apply(this.size() - 1 - param);
            }
        };
    }

    @Override
    public ListSharp<T> sorted() {
        return this.sorted((Comparator)new AbstractSharpCollection.DefaultComparator());
    }

    @Override
    public ListSharp<T> sorted(Comparator<? super T> comparator) {
        if (this.isEmpty()) {
            return this;
        }
        Object[] novosDados = Arrays.copyOf(this.data, this.data.length);
        Arrays.sort(novosDados, comparator);
        return new ListSharp<T>(novosDados, this.startIndex, this.startIndex + this.theSize);
    }

    public <A> MapSharp<A, ListSharp<T>> groupBy(Function1<T, A> function) {
        return this.groupBy(function, MapSharp.MapSharpType.HASH_MAP);
    }

    public <A> MapSharp<A, ListSharp<T>> groupBy(Function1<T, A> function, MapSharp.MapSharpType mapType) {
        MapSharp mapaIntermediario = MapSharp.empty(mapType);
        for (Object curEle : this) {
            A value = function.apply(curEle);
            ImArrayBuilder builder = (ImArrayBuilder)mapaIntermediario.get(value);
            if (builder == null) {
                builder = new ImArrayBuilder();
                mapaIntermediario.add(value, builder);
            }
            builder.add(curEle);
        }
        MapSharp mapaRetorno = MapSharp.empty(mapType);
        for (Object curEle : mapaIntermediario.keySet()) {
            mapaRetorno.add(curEle, (ListSharp)((Builder)mapaIntermediario.get(curEle)).result());
        }
        return mapaRetorno;
    }

    private class ImArrayBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private final List<E> list = new ArrayList();

        private ImArrayBuilder() {
        }

        @Override
        public void add(E element) {
            this.list.add(element);
        }

        @Override
        public ListSharp<E> result() {
            return new ListSharp(this.list.toArray());
        }
    }
}

