/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.immutable;

import com.github.detentor.codex.collections.AbstractIndexedSeq;
import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.IndexedSeq;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.collections.immutable.ListSharp;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.product.Tuple2;
import com.github.detentor.operations.CharOps;
import com.github.detentor.operations.StringOps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class RichString
extends AbstractIndexedSeq<Character, RichString>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final RichString EMPTY = new RichString("");
    private final String value;

    public static RichString empty() {
        return EMPTY;
    }

    public static RichString from(String theValue) {
        return theValue == null ? RichString.empty() : new RichString(theValue);
    }

    protected RichString(String theValue) {
        this.value = theValue;
    }

    @Override
    public Character apply(Integer pos) {
        return Character.valueOf(this.value.charAt(pos));
    }

    @Override
    public int size() {
        return this.value.length();
    }

    public RichString subsequence(int startIndex, int endIndex) {
        return RichString.from(this.value.substring(startIndex, endIndex));
    }

    @Override
    public Builder<Character, SharpCollection<Character>> builder() {
        return new RichStringBuilder();
    }

    @Override
    public <B> IndexedSeq<B> map(Function1<? super Character, B> function) {
        return ListSharp.from(CharOps.lift(this.value.toCharArray())).map(function);
    }

    public RichString map(Function1<? super Character, Character> function) {
        return (RichString)super.map(function);
    }

    @Override
    public <B> IndexedSeq<B> flatMap(Function1<? super Character, ? extends SharpCollection<B>> function) {
        return ListSharp.from(CharOps.lift(this.value.toCharArray())).flatMap(function);
    }

    public RichString flatMap(Function1<? super Character, ? extends RichString> function) {
        return (RichString)super.flatMap(function);
    }

    @Override
    public <B> IndexedSeq<B> collect(PartialFunction1<? super Character, B> pFunction) {
        return ListSharp.from(CharOps.lift(this.value.toCharArray())).collect(pFunction);
    }

    public RichString collect(PartialFunction1<? super Character, Character> pFunction) {
        return (RichString)super.collect(pFunction);
    }

    @Override
    public IndexedSeq<Tuple2<Character, Integer>> zipWithIndex() {
        return ListSharp.from(CharOps.lift(this.value.toCharArray())).zipWithIndex();
    }

    public RichString add(String stringToAdd) {
        return stringToAdd == null ? this : RichString.from(this.value + stringToAdd);
    }

    public RichString replaceAll(String regex, String replacement) {
        return RichString.from(this.value.replaceAll(regex, replacement));
    }

    public RichString toProperCase() {
        return RichString.from((String)StringOps.toProperCase.apply(this.toString()));
    }

    public RichString toLowerCase() {
        return RichString.from(this.value.toLowerCase());
    }

    public RichString toUpperCase() {
        return RichString.from(this.value.toUpperCase());
    }

    public RichString trim() {
        return RichString.from(this.value.trim());
    }

    public boolean equals(String theString) {
        return this.value.equals(theString);
    }

    public boolean equalsIgnoreCase(String theString) {
        return this.value.equalsIgnoreCase(theString);
    }

    public RichString sorted() {
        char[] chars = this.value.toCharArray();
        Arrays.sort(chars);
        return RichString.from(String.valueOf(chars));
    }

    @Override
    public RichString reverse() {
        int upperBound = this.value.length() / 2;
        char[] reversedStr = this.value.toCharArray();
        int lastIndex = this.value.length() - 1;
        int tempChar = 32;
        for (int i = 0; i < upperBound; ++i) {
            tempChar = reversedStr[i];
            reversedStr[i] = reversedStr[lastIndex];
            reversedStr[lastIndex--] = tempChar;
        }
        return RichString.from(String.valueOf(reversedStr));
    }

    public String toString() {
        return this.value;
    }

    public RichString sorted(Comparator<? super Character> comparator) {
        return RichString.from(((AbstractSharpCollection)ListSharp.from(this).sorted(comparator)).mkString());
    }

    private static final class RichStringBuilder
    implements Builder<Character, SharpCollection<Character>> {
        private final StringBuilder sBuilder = new StringBuilder();

        private RichStringBuilder() {
        }

        @Override
        public void add(Character element) {
            this.sBuilder.append(element);
        }

        @Override
        public RichString result() {
            return RichString.from(this.sBuilder.toString());
        }
    }
}

