/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.mutable;

import com.github.detentor.codex.collections.AbstractMutableLinearSeq;
import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.collections.immutable.ListSharp;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.monads.Option;
import com.github.detentor.codex.product.Tuple2;
import java.util.Comparator;

public class LLSharp<T>
extends AbstractMutableLinearSeq<T, LLSharp<T>> {
    private T head;
    private LLSharp<T> tail;
    private static final LLSharp<Object> Nil = new LLSharp<Object>(null, null);

    protected LLSharp() {
        this(null, null);
    }

    protected LLSharp(T theHead) {
        this(theHead, Nil);
    }

    protected LLSharp(T theHead, LLSharp<T> theTail) {
        this.head = theHead;
        this.tail = theTail;
    }

    public static <A> LLSharp<A> empty() {
        return new LLSharp();
    }

    public static <T> LLSharp<T> from(T valor) {
        return LLSharp.empty().add((Object)valor);
    }

    public static <T> LLSharp<T> from(T ... valores) {
        LLSharp retorno = LLSharp.empty();
        for (int i = valores.length - 1; i > -1; --i) {
            retorno.add((Object)valores[i]);
        }
        return retorno;
    }

    public static <T> LLSharp<T> from(Iterable<T> theIterable) {
        LinkedListBuilder<T> builder = new LinkedListBuilder<T>();
        for (T ele : theIterable) {
            builder.add(ele);
        }
        return builder.result();
    }

    @Override
    public boolean isEmpty() {
        return this.head() == null && this.tail() == null;
    }

    @Override
    public T head() {
        return this.head;
    }

    @Override
    public LLSharp<T> tail() {
        return this.tail;
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        return new LinkedListBuilder();
    }

    @Override
    public LLSharp<T> add(T element) {
        LLSharp<T> prevElement = new LLSharp<T>(this.head, this.tail);
        this.head = element;
        this.tail = prevElement;
        return this;
    }

    @Override
    public LLSharp<T> remove(T element) {
        if (this.isEmpty()) {
            return this;
        }
        if (Option.from(this.head).equals(Option.from(element))) {
            this.head = this.tail.head;
            this.tail = this.tail.tail;
        } else {
            this.tail = this.tail.remove((Object)element);
        }
        return this;
    }

    @Override
    public LLSharp<T> addAll(Iterable<? extends T> col) {
        for (T ele : col) {
            this.add((Object)ele);
        }
        return this;
    }

    @Override
    public LLSharp<T> removeAll(Iterable<T> col) {
        for (T ele : col) {
            this.remove((Object)ele);
        }
        return this;
    }

    @Override
    public LLSharp<T> clear() {
        this.head = null;
        this.tail = null;
        return this;
    }

    public String toString() {
        return this.mkString("[", ", ", "]");
    }

    @Override
    public <B> LLSharp<B> map(Function1<? super T, B> function) {
        return (LLSharp)super.map(function);
    }

    @Override
    public <B> LLSharp<B> collect(PartialFunction1<? super T, B> pFunction) {
        return (LLSharp)super.collect(pFunction);
    }

    @Override
    public <B> LLSharp<B> flatMap(Function1<? super T, ? extends SharpCollection<B>> function) {
        return (LLSharp)super.flatMap(function);
    }

    @Override
    public LLSharp<Tuple2<T, Integer>> zipWithIndex() {
        return (LLSharp)super.zipWithIndex();
    }

    @Override
    public LLSharp<T> sorted() {
        return this.sorted((Comparator)new AbstractSharpCollection.DefaultComparator());
    }

    @Override
    public LLSharp<T> sorted(Comparator<? super T> comparator) {
        return LLSharp.from(ListSharp.from(this).sorted((Comparator)comparator));
    }

    private static final class LinkedListBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private LLSharp<E> list = LLSharp.empty();
        private LLSharp<E> last;

        private LinkedListBuilder() {
        }

        @Override
        public void add(E element) {
            if (this.list.isEmpty()) {
                this.list = LLSharp.from(element);
                this.last = this.list;
            } else {
                LLSharp<E> novoEle = LLSharp.from(element);
                ((LLSharp)this.last).tail = (LLSharp)novoEle;
                this.last = novoEle;
            }
        }

        @Override
        public LLSharp<E> result() {
            return this.list;
        }
    }
}

