/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.mutable;

import com.github.detentor.codex.collections.AbstractMutableIndexedSeq;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.IndexedSeq;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.collections.mutable.MapSharp;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.product.Tuple2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListSharp<T>
extends AbstractMutableIndexedSeq<T, ListSharp<T>>
implements PartialFunction1<Integer, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> backingList;

    protected ListSharp() {
        this(new ArrayList());
    }

    protected ListSharp(List<T> fromList) {
        this.backingList = fromList;
    }

    public static <A> ListSharp<A> empty() {
        return new ListSharp();
    }

    public static <T> ListSharp<T> from(Iterable<T> theIterable) {
        ListSharp<T> retorno = new ListSharp<T>();
        for (T ele : theIterable) {
            retorno.add((Object)ele);
        }
        return retorno;
    }

    public static <T> ListSharp<T> from(T ... valores) {
        ListSharp<T> retorno = new ListSharp<T>();
        for (T ele : valores) {
            retorno.add((Object)ele);
        }
        return retorno;
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean contains(T element) {
        return this.backingList.contains(element);
    }

    @Override
    public ListSharp<T> add(T element) {
        this.backingList.add(element);
        return this;
    }

    @Override
    public ListSharp<T> remove(T element) {
        this.backingList.remove(element);
        return this;
    }

    @Override
    public ListSharp<T> clear() {
        this.backingList.clear();
        return this;
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        return new ArrayBuilder();
    }

    public String toString() {
        return this.mkString("[", ", ", "]");
    }

    @Override
    public <B> ListSharp<B> collect(PartialFunction1<? super T, B> pFunction) {
        return (ListSharp)super.collect(pFunction);
    }

    @Override
    public <B> ListSharp<B> map(Function1<? super T, B> function) {
        return (ListSharp)super.map(function);
    }

    @Override
    public <B> ListSharp<B> flatMap(Function1<? super T, ? extends SharpCollection<B>> function) {
        return (ListSharp)super.flatMap(function);
    }

    @Override
    public ListSharp<Tuple2<T, Integer>> zipWithIndex() {
        return (ListSharp)super.zipWithIndex();
    }

    public <A> MapSharp<A, ListSharp<T>> groupBy(Function1<T, A> function) {
        return this.groupBy(function, MapSharp.MapSharpType.HASH_MAP);
    }

    public <A> MapSharp<A, ListSharp<T>> groupBy(Function1<T, A> function, MapSharp.MapSharpType mapType) {
        MapSharp mapaRetorno = MapSharp.empty(mapType);
        for (Object curEle : this) {
            A value = function.apply(curEle);
            mapaRetorno.add(value, mapaRetorno.getOrElse(value, ListSharp.<A>empty()).add(curEle));
        }
        return mapaRetorno;
    }

    public <A> MapSharp<A, T> mapped(Function1<T, A> function) {
        MapSharp mapaRetorno = MapSharp.empty();
        for (Object curEle : this) {
            mapaRetorno.add(Tuple2.from(function.apply(curEle), curEle));
        }
        return mapaRetorno;
    }

    @Override
    public ListSharp<T> sorted() {
        return this.sorted((Comparator)new DefaultComparator());
    }

    @Override
    public ListSharp<T> sorted(Comparator<? super T> comparator) {
        if (this.isEmpty()) {
            return this;
        }
        Collections.sort(this.backingList, comparator);
        return this;
    }

    @Override
    public IndexedSeq<T> subsequence(int startIndex, int endIndex) {
        return ListSharp.from(this.backingList.subList(Math.max(startIndex, 0), Math.min(endIndex, this.size())));
    }

    @Override
    public T apply(Integer param) {
        return this.backingList.get(param);
    }

    @Override
    public List<T> toList() {
        return this.backingList;
    }

    protected static final class ArrayBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private final List<E> list = new ArrayList();

        protected ArrayBuilder() {
        }

        @Override
        public void add(E element) {
            this.list.add(element);
        }

        @Override
        public ListSharp<E> result() {
            return new ListSharp<E>(this.list);
        }
    }

    private static final class DefaultComparator<A extends Comparable<A>>
    implements Comparator<A>,
    Serializable {
        private static final long serialVersionUID = 4989261028786246998L;

        private DefaultComparator() {
        }

        @Override
        public int compare(A ob1, A ob2) {
            return ob1.compareTo(ob2);
        }
    }
}

