/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.mutable;

import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.collections.mutable.ListSharp;
import com.github.detentor.codex.collections.mutable.SetSharp;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.product.Tuple2;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class MapSharp<K, V>
extends AbstractSharpCollection<Tuple2<K, V>, MapSharp<K, V>>
implements PartialFunction1<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> backingMap;

    protected MapSharp() {
        this(new HashMap());
    }

    protected MapSharp(Map<K, V> fromMap) {
        this.backingMap = fromMap;
    }

    @Override
    public V apply(K param) {
        return this.backingMap.get(param);
    }

    @Override
    public boolean isDefinedAt(K forValue) {
        return this.backingMap.containsKey(forValue);
    }

    public static <T, U> MapSharp<T, U> from(Map<T, U> theMap) {
        MapSharp<T, U> retorno = new MapSharp<T, U>();
        for (Map.Entry<T, U> ele : theMap.entrySet()) {
            retorno.add(Tuple2.from(ele.getKey(), ele.getValue()));
        }
        return retorno;
    }

    public static <T, U> MapSharp<T, U> from(Iterable<Tuple2<T, U>> theIterable) {
        MapSharp<T, U> retorno = new MapSharp<T, U>();
        for (Tuple2<T, U> ele : theIterable) {
            retorno.add(ele);
        }
        return retorno;
    }

    public static <T, U> MapSharp<T, U> empty() {
        return new MapSharp();
    }

    public static <T, U> MapSharp<T, U> empty(MapSharpType mapType) {
        AbstractMap mapInstance = null;
        switch (mapType) {
            case HASH_MAP: {
                mapInstance = new HashMap();
                break;
            }
            case LINKED_HASH_MAP: {
                mapInstance = new LinkedHashMap();
                break;
            }
            case TREE_MAP: {
                mapInstance = new TreeMap();
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo de MapSharp n\u00e3o reconhecido");
            }
        }
        return new MapSharp(mapInstance);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return new Iterator<Tuple2<K, V>>(){
            private final Iterator<Map.Entry<K, V>> originalIte;
            {
                this.originalIte = MapSharp.this.backingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.originalIte.hasNext();
            }

            @Override
            public Tuple2<K, V> next() {
                Map.Entry entry = this.originalIte.next();
                return Tuple2.from(entry.getKey(), entry.getValue());
            }

            @Override
            public void remove() {
                this.originalIte.remove();
            }
        };
    }

    public SetSharp<K> keySet() {
        return SetSharp.from(this.backingMap.keySet());
    }

    public SharpCollection<V> values() {
        return ListSharp.from(this.backingMap.values());
    }

    public MapSharp<K, V> add(Tuple2<K, V> element) {
        this.backingMap.put(element.getVal1(), element.getVal2());
        return this;
    }

    public MapSharp<K, V> clear() {
        this.backingMap.clear();
        return this;
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        Builder builderRetorno = null;
        if (this.backingMap instanceof HashSet) {
            builderRetorno = new HashMapBuilder();
        } else if (this.backingMap instanceof LinkedHashSet) {
            builderRetorno = new LinkedHashMapBuilder();
        } else if (this.backingMap instanceof TreeSet) {
            builderRetorno = new TreeMapBuilder();
        } else {
            throw new IllegalArgumentException("Tipo de inst\u00e2ncia n\u00e3o reconhecida");
        }
        return builderRetorno;
    }

    @Override
    public boolean contains(Tuple2<K, V> element) {
        return super.contains(element);
    }

    @Override
    public boolean containsAll(SharpCollection<Tuple2<K, V>> col) {
        return super.containsAll(col);
    }

    public MapSharp<K, V> removeKey(K key) {
        this.backingMap.remove(key);
        return this;
    }

    public MapSharp<K, V> add(K key, V value) {
        this.backingMap.put(key, value);
        return this;
    }

    public V get(K key) {
        return this.backingMap.get(key);
    }

    public V getOrElse(K key, V elsePart) {
        V value = this.backingMap.get(key);
        if (value != null || this.backingMap.containsKey(key)) {
            return value;
        }
        return elsePart;
    }

    public boolean containsKey(K key) {
        return this.backingMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.backingMap.containsValue(value);
    }

    public <W, Y> MapSharp<W, Y> map(Function1<Tuple2<K, V>, Tuple2<W, Y>> function) {
        return (MapSharp)super.map(function);
    }

    @Override
    public <B> SharpCollection<B> map(Function1<? super Tuple2<K, V>, B> function) {
        ListSharp.ArrayBuilder colecaoRetorno = new ListSharp.ArrayBuilder();
        for (Tuple2<K, V> ele : this) {
            colecaoRetorno.add(function.apply(ele));
        }
        return (SharpCollection)colecaoRetorno.result();
    }

    public <W, Y> MapSharp<W, Y> collect(PartialFunction1<Tuple2<K, V>, Tuple2<W, Y>> pFunction) {
        return (MapSharp)super.collect(pFunction);
    }

    @Override
    public <B> SharpCollection<B> collect(PartialFunction1<? super Tuple2<K, V>, B> pFunction) {
        ListSharp.ArrayBuilder colecaoRetorno = new ListSharp.ArrayBuilder();
        for (Tuple2<K, V> ele : this) {
            if (!pFunction.isDefinedAt(ele)) continue;
            colecaoRetorno.add(pFunction.apply(ele));
        }
        return (SharpCollection)colecaoRetorno.result();
    }

    public <W, Y> MapSharp<W, Y> flatMap(Function1<Tuple2<K, V>, ? extends SharpCollection<Tuple2<W, Y>>> function) {
        return (MapSharp)super.flatMap(function);
    }

    @Override
    public <B> SharpCollection<B> flatMap(Function1<? super Tuple2<K, V>, ? extends SharpCollection<B>> function) {
        ListSharp.ArrayBuilder colecaoRetorno = new ListSharp.ArrayBuilder();
        for (Tuple2<K, V> ele : this) {
            for (B mappedEle : function.apply(ele)) {
                colecaoRetorno.add(mappedEle);
            }
        }
        return (SharpCollection)colecaoRetorno.result();
    }

    public Map<K, V> toMap() {
        return this.backingMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backingMap == null ? 0 : ((Object)this.backingMap).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapSharp other = (MapSharp)obj;
        return !(this.backingMap == null ? other.backingMap != null : !((Object)this.backingMap).equals(other.backingMap));
    }

    public String toString() {
        return this.backingMap.toString();
    }

    public MapSharp<K, V> sorted() {
        return this.sorted((Comparator)new AbstractSharpCollection.DefaultComparator());
    }

    public MapSharp<K, V> sorted(Comparator<? super Tuple2<K, V>> comparator) {
        MapSharp mapaRetorno = MapSharp.empty(MapSharpType.LINKED_HASH_MAP);
        for (Tuple2 curEle : ListSharp.from(this).sorted(comparator)) {
            mapaRetorno.add(curEle);
        }
        return mapaRetorno;
    }

    public static enum MapSharpType {
        HASH_MAP,
        LINKED_HASH_MAP,
        TREE_MAP;

    }

    private class TreeMapBuilder<X, Y>
    implements Builder<Tuple2<X, Y>, SharpCollection<Tuple2<X, Y>>> {
        private final Map<X, Y> hashMap = new TreeMap<X, Y>();

        private TreeMapBuilder() {
        }

        @Override
        public void add(Tuple2<X, Y> element) {
            this.hashMap.put(element.getVal1(), element.getVal2());
        }

        @Override
        public MapSharp<X, Y> result() {
            return new MapSharp<X, Y>(this.hashMap);
        }
    }

    private class LinkedHashMapBuilder<X, Y>
    implements Builder<Tuple2<X, Y>, SharpCollection<Tuple2<X, Y>>> {
        private final Map<X, Y> hashMap = new LinkedHashMap<X, Y>();

        private LinkedHashMapBuilder() {
        }

        @Override
        public void add(Tuple2<X, Y> element) {
            this.hashMap.put(element.getVal1(), element.getVal2());
        }

        @Override
        public MapSharp<X, Y> result() {
            return new MapSharp<X, Y>(this.hashMap);
        }
    }

    private class HashMapBuilder<X, Y>
    implements Builder<Tuple2<X, Y>, SharpCollection<Tuple2<X, Y>>> {
        private final Map<X, Y> hashMap = new HashMap<X, Y>();

        private HashMapBuilder() {
        }

        @Override
        public void add(Tuple2<X, Y> element) {
            this.hashMap.put(element.getVal1(), element.getVal2());
        }

        @Override
        public MapSharp<X, Y> result() {
            return new MapSharp<X, Y>(this.hashMap);
        }
    }
}

