/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections.mutable;

import com.github.detentor.codex.collections.AbstractMutableGenericCollection;
import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.product.Tuple2;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public class SetSharp<T>
extends AbstractMutableGenericCollection<T, SetSharp<T>>
implements PartialFunction1<T, Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<T> backingSet;

    protected SetSharp() {
        this(new HashSet());
    }

    protected SetSharp(Set<T> fromSet) {
        this.backingSet = fromSet;
    }

    public static <T> SetSharp<T> from(Iterable<T> theIterable) {
        SetSharp<T> retorno = new SetSharp<T>();
        for (T ele : theIterable) {
            retorno.add((Object)ele);
        }
        return retorno;
    }

    public static <T> SetSharp<T> from(T ... valores) {
        SetSharp<T> retorno = new SetSharp<T>();
        for (T ele : valores) {
            retorno.add((Object)ele);
        }
        return retorno;
    }

    public static <T> SetSharp<T> empty() {
        return new SetSharp<T>();
    }

    public static <T> SetSharp<T> empty(SetSharpType setType) {
        AbstractSet hashInstance = null;
        switch (setType) {
            case HASH_SET: {
                hashInstance = new HashSet();
                break;
            }
            case LINKED_HASH_SET: {
                hashInstance = new LinkedHashSet();
                break;
            }
            case TREE_SET: {
                hashInstance = new TreeSet();
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo de SetSharp n\u00e3o reconhecido");
            }
        }
        return new SetSharp(hashInstance);
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean contains(T element) {
        return this.backingSet.contains(element);
    }

    @Override
    public Iterator<T> iterator() {
        return this.backingSet.iterator();
    }

    @Override
    public SetSharp<T> add(T element) {
        this.backingSet.add(element);
        return this;
    }

    @Override
    public SetSharp<T> remove(T element) {
        this.backingSet.remove(element);
        return this;
    }

    @Override
    public SetSharp<T> clear() {
        this.backingSet.clear();
        return this;
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        Builder builderRetorno = null;
        if (this.backingSet instanceof HashSet) {
            builderRetorno = new HashSetBuilder();
        } else if (this.backingSet instanceof LinkedHashSet) {
            builderRetorno = new LinkedHashBuilder();
        } else if (this.backingSet instanceof TreeSet) {
            builderRetorno = new TreeSetBuilder();
        } else {
            throw new IllegalArgumentException("Tipo de inst\u00e2ncia n\u00e3o reconhecida");
        }
        return builderRetorno;
    }

    @Override
    public <B> SetSharp<B> map(Function1<? super T, B> function) {
        return (SetSharp)super.map(function);
    }

    @Override
    public <B> SetSharp<B> flatMap(Function1<? super T, ? extends SharpCollection<B>> function) {
        return (SetSharp)super.flatMap(function);
    }

    @Override
    public <B> SetSharp<B> collect(PartialFunction1<? super T, B> pFunction) {
        return (SetSharp)super.collect(pFunction);
    }

    @Override
    public SetSharp<Tuple2<T, Integer>> zipWithIndex() {
        return (SetSharp)super.zipWithIndex();
    }

    @Override
    public Boolean apply(T param) {
        return this.backingSet.contains(param);
    }

    @Override
    public boolean isDefinedAt(T forValue) {
        return this.backingSet.contains(forValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backingSet == null ? 0 : ((Object)this.backingSet).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetSharp other = (SetSharp)obj;
        return !(this.backingSet == null ? other.backingSet != null : !((Object)this.backingSet).equals(other.backingSet));
    }

    public String toString() {
        return this.backingSet.toString();
    }

    @Override
    public SetSharp<T> sorted() {
        return this.sorted((Comparator)new AbstractSharpCollection.DefaultComparator());
    }

    @Override
    public SetSharp<T> sorted(Comparator<? super T> comparator) {
        return (SetSharp)SetSharp.from(new TreeSet<T>(comparator)).addAll(this);
    }

    public static enum SetSharpType {
        HASH_SET,
        LINKED_HASH_SET,
        TREE_SET;

    }

    private static final class LinkedHashBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private final Set<E> backingSet = new LinkedHashSet();

        private LinkedHashBuilder() {
        }

        @Override
        public void add(E element) {
            this.backingSet.add(element);
        }

        @Override
        public SetSharp<E> result() {
            return new SetSharp<E>(this.backingSet);
        }
    }

    private static final class TreeSetBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private final Set<E> backingSet = new TreeSet();

        private TreeSetBuilder() {
        }

        @Override
        public void add(E element) {
            this.backingSet.add(element);
        }

        @Override
        public SetSharp<E> result() {
            return new SetSharp<E>(this.backingSet);
        }
    }

    private static final class HashSetBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private final Set<E> backingSet = new HashSet();

        private HashSetBuilder() {
        }

        @Override
        public void add(E element) {
            this.backingSet.add(element);
        }

        @Override
        public SetSharp<E> result() {
            return new SetSharp<E>(this.backingSet);
        }
    }
}

