/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.function;

import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.PartialFunction1;
import com.github.detentor.codex.function.arrow.Arrow1;

public final class Functions {
    private Functions() {
    }

    public static <A, B, C> Arrow1<A, C> compose(final Function1<? super A, B> function1, final Function1<? super B, C> function2) {
        return new Arrow1<A, C>(){

            @Override
            public C apply(A param) {
                return function2.apply(function1.apply(param));
            }
        };
    }

    public static <A, B, C> Arrow1<A, Boolean> composeBool(final Function1<? super A, Boolean> function1, final Function1<? super A, Boolean> function2) {
        return new Arrow1<A, Boolean>(){

            @Override
            public Boolean apply(A param) {
                return (Boolean)function1.apply(param) != false && (Boolean)function2.apply(param) != false;
            }
        };
    }

    public static <A, B, C> PartialFunction1<A, C> compose(final PartialFunction1<? super A, B> function1, final Function1<? super B, C> function2) {
        return new PartialFunction1<A, C>(){

            @Override
            public C apply(A param) {
                return function2.apply(function1.apply(param));
            }

            @Override
            public boolean isDefinedAt(A forValue) {
                return function1.isDefinedAt(forValue);
            }
        };
    }

    public static <A, B, C> PartialFunction1<A, C> compose(final Function1<? super A, B> function1, final PartialFunction1<? super B, C> function2) {
        return new PartialFunction1<A, C>(){

            @Override
            public C apply(A param) {
                return function2.apply(function1.apply(param));
            }

            @Override
            public boolean isDefinedAt(A forValue) {
                return function2.isDefinedAt(function1.apply(forValue));
            }
        };
    }

    public static <A, B, C> PartialFunction1<A, C> compose(final PartialFunction1<? super A, B> function1, final PartialFunction1<? super B, C> function2) {
        return new PartialFunction1<A, C>(){

            @Override
            public C apply(A param) {
                return function2.apply(function1.apply(param));
            }

            @Override
            public boolean isDefinedAt(A forValue) {
                return function1.isDefinedAt(forValue) && function2.isDefinedAt(function1.apply(forValue));
            }
        };
    }

    public static <A> Arrow1<A, Boolean> not(final Function1<A, Boolean> theFunction) {
        return new Arrow1<A, Boolean>(){

            @Override
            public Boolean apply(A param) {
                return (Boolean)theFunction.apply(param) == false;
            }
        };
    }

    public static <A, B> PartialFunction1<A, B> createPartial(Function1<? super A, Boolean> pred, Function1<? super A, B> transform) {
        return new PartialCreation<A, B>(pred, transform);
    }

    private static final class PartialCreation<A, B>
    implements PartialFunction1<A, B> {
        private final Function1<? super A, Boolean> predicate;
        private final Function1<? super A, B> mappingFunction;

        public PartialCreation(Function1<? super A, Boolean> thePredicate, Function1<? super A, B> theMappingFunction) {
            this.predicate = thePredicate;
            this.mappingFunction = theMappingFunction;
        }

        @Override
        public B apply(A param) {
            return this.mappingFunction.apply(param);
        }

        @Override
        public boolean isDefinedAt(A forValue) {
            return this.predicate.apply(forValue);
        }
    }
}

