/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.io;

import com.github.detentor.codex.collections.mutable.ListSharp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class Files {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private Files() {
    }

    public static byte[] readBytes(String fileName) {
        File arq = new File(fileName);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(arq);
            byte[] data = new byte[(int)arq.length()];
            fis.read(data);
            fis.close();
            return data;
        }
        catch (IOException ioe) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe2) {
                    throw new IllegalArgumentException(ioe2);
                }
            }
            throw new IllegalArgumentException(ioe);
        }
    }

    public static String readString(String fileName) {
        return Files.readString(fileName, "cp1252");
    }

    public static String readString(String fileName, String charsetName) {
        try {
            return new String(Files.readBytes(fileName), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ListSharp<String> readLines(String fileName) {
        return ListSharp.from(Files.readString(fileName).split(LINE_SEPARATOR));
    }

    public static void writeBytes(String fileName, byte[] dados) {
        File arq = new File(fileName);
        FileOutputStream fis = null;
        try {
            fis = new FileOutputStream(arq);
            fis.write(dados);
            fis.close();
        }
        catch (IOException ioe) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe2) {
                    throw new IllegalArgumentException(ioe2);
                }
            }
            throw new IllegalArgumentException(ioe);
        }
    }

    public static void writeString(String fileName, String theString) {
        Files.writeBytes(fileName, theString.getBytes());
    }
}

