/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.monads;

import com.github.detentor.codex.collections.AbstractSharpCollection;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.product.Tuple2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Option<T>
extends AbstractSharpCollection<T, SharpCollection<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Option<Object> NONE = new Option();
    private final List<T> value = new ArrayList<T>(1);

    protected Option() {
    }

    protected Option(T theValue) {
        this();
        this.value.add(theValue);
    }

    public static <T> Option<T> empty() {
        return NONE;
    }

    public static <T> Option<T> from(T theValue) {
        return theValue == null ? NONE : new Option<T>(theValue);
    }

    public T get() {
        if (this.value.isEmpty()) {
            throw new NoSuchElementException("option n\u00e3o possui elementos");
        }
        return this.value.get(0);
    }

    public T getOrElse(T elsePart) {
        return this.value.isEmpty() ? elsePart : this.get();
    }

    public String toString() {
        return this.isEmpty() ? "None" : "Some(" + this.get().toString() + ")";
    }

    @Override
    public int size() {
        return this.value.isEmpty() ? 0 : 1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            boolean readValue = false;

            @Override
            public boolean hasNext() {
                return Option.this.notEmpty() && !this.readValue;
            }

            @Override
            public T next() {
                if (this.readValue || Option.this.isEmpty()) {
                    throw new NoSuchElementException("o iterator n\u00e3o possui mais elementos");
                }
                this.readValue = true;
                return Option.this.get();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("opera\u00e7\u00e3o n\u00e3o suportada");
            }
        };
    }

    @Override
    public <B> Builder<B, SharpCollection<B>> builder() {
        return new OptionBuilder();
    }

    @Override
    public <B> Option<B> map(Function1<? super T, B> function) {
        return (Option)super.map(function);
    }

    @Override
    public <B> Option<B> flatMap(Function1<? super T, ? extends SharpCollection<B>> function) {
        return (Option)super.flatMap(function);
    }

    @Override
    public Option<Tuple2<T, Integer>> zipWithIndex() {
        return (Option)super.zipWithIndex();
    }

    @Override
    public Option<T> sorted() {
        return this;
    }

    @Override
    public Option<T> sorted(Comparator<? super T> comparator) {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.value).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Object)this.value).equals(((Option)obj).value);
    }

    private class OptionBuilder<E>
    implements Builder<E, SharpCollection<E>> {
        private boolean added = false;
        private E valor = null;

        private OptionBuilder() {
        }

        @Override
        public void add(E element) {
            if (this.added) {
                throw new IllegalStateException("tentou-se adicionar mais de um elemento no builder do option");
            }
            this.added = true;
            this.valor = element;
        }

        @Override
        public Option<E> result() {
            return Option.from(this.valor);
        }
    }
}

