/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.util;

import com.github.detentor.codex.function.arrow.Arrow1;
import com.github.detentor.codex.function.arrow.ArrowN;
import com.github.detentor.codex.monads.Option;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class Reflections {
    private Reflections() {
    }

    public static <A, B> Arrow1<A, B> lift(Class<A> fromClass, String methodName) {
        final Method theMethod = Reflections.ensureNotEmpty(Reflections.getMethodFromName(fromClass, methodName));
        return new Arrow1<A, B>(){

            @Override
            public B apply(A param) {
                return Reflections.invokeSafe(param, theMethod, null);
            }
        };
    }

    public static <A, B, C> Arrow1<B, C> liftStatic(final Class<A> fromClass, String methodName) {
        final Method theMethod = Reflections.ensureNotEmpty(Reflections.getMethodFromName(fromClass, methodName));
        return new Arrow1<B, C>(){

            @Override
            public C apply(B param) {
                return Reflections.invokeSafe(fromClass, theMethod, param);
            }
        };
    }

    public static <A, B, C> ArrowN<B, C> liftStaticVarArgs(final Class<A> fromClass, String methodName) {
        final Method theMethod = Reflections.ensureNotEmpty(Reflections.getMethodFromNameAndType(fromClass, methodName, new Class[]{Object[].class}));
        return new ArrowN<B, C>(){

            @Override
            public C apply(B ... params) {
                return Reflections.invokeSafe(fromClass, theMethod, new Object[]{params});
            }
        };
    }

    private static Method ensureNotEmpty(Option<Method> theOption) {
        if (theOption.isEmpty()) {
            throw new IllegalArgumentException("The named method doesn't exist");
        }
        return theOption.get();
    }

    public static <A> Option<Method> getMethodFromName(Class<A> fromClass, String methodName) {
        for (Method curMethod : fromClass.getDeclaredMethods()) {
            if (!curMethod.getName().equals(methodName)) continue;
            return Option.from(curMethod);
        }
        Class<A> superClass = fromClass.getSuperclass();
        return superClass == null ? Option.empty() : Reflections.getMethodFromName(superClass, methodName);
    }

    public static <A> Option<Method> getMethodFromNameAndType(Class<A> fromClass, String methodName, Class<?>[] parameterType) {
        for (Method curMethod : fromClass.getDeclaredMethods()) {
            if (!curMethod.getName().equals(methodName) || !Arrays.equals(curMethod.getParameterTypes(), parameterType)) continue;
            return Option.from(curMethod);
        }
        Class<A> superClass = fromClass.getSuperclass();
        return superClass == null ? Option.empty() : Reflections.getMethodFromNameAndType(superClass, methodName, parameterType);
    }

    public static <A> Option<Field> fieldFromName(Class<A> fromClass, String fieldName) {
        for (Field curField : fromClass.getDeclaredFields()) {
            if (!curField.getName().equals(fieldName)) continue;
            return Option.from(curField);
        }
        Class<A> superClass = fromClass.getSuperclass();
        return superClass == null ? Option.empty() : Reflections.fieldFromName(superClass, fieldName);
    }

    public static <A, B> B invokeSafe(Object fromClass, Method method, Object ... params) {
        try {
            return (B)method.invoke(fromClass, params);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(Class<T> type) throws IllegalArgumentException {
        return Reflections.newInstance(type, null);
    }

    public static <T> T newInstance(Class<T> type, Object ... params) throws IllegalArgumentException {
        try {
            if (params == null || params.length == 0) {
                return type.newInstance();
            }
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = params[i].getClass();
            }
            return type.getConstructor(paramTypes).newInstance(params);
        }
        catch (InstantiationException instEx) {
            throw new IllegalArgumentException("A classe " + type + " n\u00e3o possui construtor p\u00fablico", instEx);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("A classe " + type + " n\u00e3o possui um construtor p\u00fablico que receba os par\u00e2metros informados", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("A classe " + type + " n\u00e3o possui um construtor p\u00fablico que receba os par\u00e2metros informados", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("A classe " + type + " n\u00e3o possui um construtor p\u00fablico que receba os par\u00e2metros informados", e);
        }
    }
}

