/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.util;

import com.github.detentor.codex.collections.immutable.ListSharp;
import com.github.detentor.codex.monads.Option;
import java.util.Iterator;

public abstract class RichIterator<E>
implements Iterator<E> {
    public abstract Option<E> peekNext();

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by this iterator");
    }

    public static <E> RichIterator<E> from(final Iterator<E> iterator) {
        return new RichIterator<E>(){
            Option<E> nextElement;
            {
                this.nextElement = iterator.hasNext() ? Option.from(iterator.next()) : Option.empty();
            }

            @Override
            public E next() {
                Object toReturn = this.nextElement.get();
                this.nextElement = iterator.hasNext() ? Option.from(iterator.next()) : Option.empty();
                return toReturn;
            }

            @Override
            public boolean hasNext() {
                return this.nextElement.notEmpty();
            }

            @Override
            public Option<E> peekNext() {
                return this.nextElement;
            }
        };
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("RichIterator: [");
        while (this.hasNext()) {
            sBuilder.append(this.next());
            if (!this.peekNext().notEmpty()) continue;
            sBuilder.append(", ");
        }
        return sBuilder.toString() + "]";
    }

    public static <E> RichIterator<E> from(Iterable<E> iterable) {
        return RichIterator.from(iterable.iterator());
    }

    public static void main(String[] args) {
        System.out.println(RichIterator.from(ListSharp.from(1, 2, 3, 4)));
    }
}

