/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dozer.BeanFactory;
import org.dozer.config.BeanContainer;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.BeanCreationStrategy;
import org.dozer.factory.ConstructionStrategies;

public final class DestBeanCreator {
    static final List<BeanCreationStrategy> pluggedStrategies = new ArrayList<BeanCreationStrategy>();
    private final BeanCreationStrategy[] availableStrategies;
    private final ConstructionStrategies constructionStrategies;
    private final BeanContainer beanContainer;

    public DestBeanCreator(BeanContainer beanContainer) {
        this.constructionStrategies = new ConstructionStrategies(beanContainer);
        this.beanContainer = beanContainer;
        this.availableStrategies = new BeanCreationStrategy[]{this.constructionStrategies.byCreateMethod(), this.constructionStrategies.byGetInstance(), this.constructionStrategies.xmlGregorianCalendar(), this.constructionStrategies.byInterface(), this.constructionStrategies.xmlBeansBased(), this.constructionStrategies.jaxbBeansBased(), this.constructionStrategies.byFactory(), this.constructionStrategies.byConstructor()};
    }

    public <T> T create(Class<T> targetClass) {
        return (T)this.create(targetClass, null);
    }

    public Object create(Class<?> targetClass, Class<?> alternateClass) {
        return this.create(new BeanCreationDirective(null, null, targetClass, alternateClass, null, null, null));
    }

    public Object create(BeanCreationDirective directive) {
        Object result = this.applyStrategies(directive, pluggedStrategies);
        if (result == null) {
            result = this.applyStrategies(directive, Arrays.asList(this.availableStrategies));
        }
        return result;
    }

    private Object applyStrategies(BeanCreationDirective directive, List<BeanCreationStrategy> strategies) {
        for (BeanCreationStrategy strategy : new CopyOnWriteArrayList<BeanCreationStrategy>(strategies)) {
            if (!strategy.isApplicable(directive)) continue;
            return strategy.create(directive);
        }
        return null;
    }

    public void setStoredFactories(Map<String, BeanFactory> factories) {
        this.constructionStrategies.byFactory().setStoredFactories(factories);
    }

    public void addPluggedStrategy(BeanCreationStrategy strategy) {
        pluggedStrategies.add(strategy);
    }
}

