/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.BowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.BunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.BunInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.BunRunner;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultBowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultBunRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultEmberRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultInstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultJspmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultKarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNpxRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultPnpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultWebpackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultYarnRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DirectoryCacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.EmberRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.InstallBunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallYarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.JspmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.KarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.NPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.NpxRunner;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.WebpackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import java.io.File;

public final class FrontendPluginFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private static final String DEFAULT_CACHE_PATH = "cache";
    private final File workingDirectory;
    private final File installDirectory;
    private final CacheResolver cacheResolver;

    public FrontendPluginFactory(File workingDirectory, File installDirectory) {
        this(workingDirectory, installDirectory, FrontendPluginFactory.getDefaultCacheResolver(installDirectory));
    }

    public FrontendPluginFactory(File workingDirectory, File installDirectory, CacheResolver cacheResolver) {
        this.workingDirectory = workingDirectory;
        this.installDirectory = installDirectory;
        this.cacheResolver = cacheResolver;
    }

    public BunInstaller getBunInstaller(ProxyConfig proxy) {
        return new BunInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public NodeInstaller getNodeInstaller(ProxyConfig proxy) {
        return new NodeInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public NPMInstaller getNPMInstaller(ProxyConfig proxy) {
        return new NPMInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public PnpmInstaller getPnpmInstaller(ProxyConfig proxy) {
        return new PnpmInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public YarnInstaller getYarnInstaller(ProxyConfig proxy) {
        return new YarnInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public BowerRunner getBowerRunner(ProxyConfig proxy) {
        return new DefaultBowerRunner(this.getExecutorConfig(), proxy);
    }

    public BunRunner getBunRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultBunRunner((BunExecutorConfig)new InstallBunExecutorConfig(this.getInstallConfig()), proxy, npmRegistryURL);
    }

    public JspmRunner getJspmRunner() {
        return new DefaultJspmRunner(this.getExecutorConfig());
    }

    public NpmRunner getNpmRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultNpmRunner(this.getExecutorConfig(), proxy, npmRegistryURL);
    }

    public PnpmRunner getPnpmRunner(ProxyConfig proxyConfig, String npmRegistryUrl) {
        return new DefaultPnpmRunner(this.getExecutorConfig(), proxyConfig, npmRegistryUrl);
    }

    public NpxRunner getNpxRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultNpxRunner(this.getExecutorConfig(), proxy, npmRegistryURL);
    }

    public YarnRunner getYarnRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultYarnRunner((YarnExecutorConfig)new InstallYarnExecutorConfig(this.getInstallConfig()), proxy, npmRegistryURL);
    }

    public GruntRunner getGruntRunner() {
        return new DefaultGruntRunner(this.getExecutorConfig());
    }

    public EmberRunner getEmberRunner() {
        return new DefaultEmberRunner(this.getExecutorConfig());
    }

    public KarmaRunner getKarmaRunner() {
        return new DefaultKarmaRunner(this.getExecutorConfig());
    }

    public GulpRunner getGulpRunner() {
        return new DefaultGulpRunner(this.getExecutorConfig());
    }

    public WebpackRunner getWebpackRunner() {
        return new DefaultWebpackRunner(this.getExecutorConfig());
    }

    private NodeExecutorConfig getExecutorConfig() {
        return new InstallNodeExecutorConfig(this.getInstallConfig());
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDirectory, this.workingDirectory, this.cacheResolver, defaultPlatform);
    }

    private static final CacheResolver getDefaultCacheResolver(File root) {
        return new DirectoryCacheResolver(new File(root, DEFAULT_CACHE_PATH));
    }
}

