/*
 * Decompiled with CFR 0.152.
 */
package com.github.eloyzone.jalalicalendar;

import com.github.eloyzone.jalalicalendar.DateConverter;
import com.github.eloyzone.jalalicalendar.DayOfWeekPersian;
import com.github.eloyzone.jalalicalendar.JalaliDateFormatter;
import com.github.eloyzone.jalalicalendar.MonthPersian;
import java.util.Objects;

public class JalaliDate {
    private int year;
    private MonthPersian monthPersian;
    private int day;
    private DayOfWeekPersian dayOfWeekPersian;
    private boolean leapYear = false;

    protected JalaliDate() {
    }

    public JalaliDate(int year, int month, int day) {
        this.basicArgumentValidating(year, month, day);
        this.setYear(year);
        this.monthPersian = MonthPersian.of(month);
        this.day = day;
        if (!this.leapYear && month == 12 && day >= 30) {
            throw new IllegalArgumentException("Wrong value for day, just in leap year last month must be greater than 29");
        }
    }

    private void basicArgumentValidating(int year, int month, int day) {
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("Wrong value for month, it must be from 1 to 12");
        }
        if (day <= 0 || day > 32) {
            throw new IllegalArgumentException("Wrong value for day, it must be from 1 to 31");
        }
        if (year <= 0) {
            throw new IllegalArgumentException("Wrong value for Year, it must be positive ");
        }
        if (month >= 7 && month <= 12 && day == 31) {
            throw new IllegalArgumentException("Wrong value for day. in second half of year, months have less than 31 days ");
        }
    }

    public String format(JalaliDateFormatter jalaliDateFormatter) {
        Objects.requireNonNull(jalaliDateFormatter, "formatter");
        return jalaliDateFormatter.format(this);
    }

    public String toString() {
        String date = this.year + "-" + this.monthPersian.getValue() + "-" + this.day;
        return date;
    }

    public int getYear() {
        return this.year;
    }

    protected void setYear(int year) {
        this.year = year;
        this.setLeapYear(new DateConverter().leapPersiana(year));
    }

    public DayOfWeekPersian getDayOfWeek() {
        if (this.dayOfWeekPersian == null) {
            this.dayOfWeekPersian = new DateConverter().getDayOfWeekPersian(this);
            return this.dayOfWeekPersian;
        }
        return this.dayOfWeekPersian;
    }

    public MonthPersian getMonthPersian() {
        return this.monthPersian;
    }

    protected void setMonthPersian(MonthPersian monthPersian) {
        this.monthPersian = monthPersian;
    }

    public int getDay() {
        return this.day;
    }

    protected void setDay(int day) {
        this.day = day;
    }

    public boolean isLeapYear() {
        return this.leapYear;
    }

    protected void setLeapYear(boolean leapYear) {
        this.leapYear = leapYear;
    }

    protected void setDayOfWeekPersian(DayOfWeekPersian dayOfWeekPersian) {
        this.dayOfWeekPersian = dayOfWeekPersian;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JalaliDate) {
            return this.compare((JalaliDate)obj);
        }
        return false;
    }

    private boolean compare(JalaliDate otherDate) {
        return this.year == otherDate.getYear() && this.monthPersian.getValue() == otherDate.monthPersian.getValue() && this.day == otherDate.day && this.getDayOfWeek().getValue() == otherDate.getDayOfWeek().getValue() && this.leapYear == otherDate.leapYear;
    }
}

