/*
 * Decompiled with CFR 0.152.
 */
package org.flips.advice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.flips.annotation.FlipBean;
import org.flips.exception.FeatureNotEnabledException;
import org.flips.exception.FlipBeanFailedException;
import org.flips.store.FlipAnnotationsStore;
import org.flips.utils.AnnotationUtils;
import org.flips.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
@Aspect
public class FlipBeanAdvice {
    private ApplicationContext applicationContext;
    private FlipAnnotationsStore flipAnnotationsStore;
    private static final Logger logger = LoggerFactory.getLogger(FlipBeanAdvice.class);

    @Autowired
    public FlipBeanAdvice(ApplicationContext applicationContext, @Lazy FlipAnnotationsStore flipAnnotationsStore) {
        this.applicationContext = applicationContext;
        this.flipAnnotationsStore = flipAnnotationsStore;
    }

    @Pointcut(value="@annotation(org.flips.annotation.FlipBean)")
    private void flipBeanPointcut() {
    }

    @Around(value="flipBeanPointcut()")
    public Object inspectFlips(ProceedingJoinPoint joinPoint) throws Throwable {
        FlipBean annotation;
        Class<?> tobeFlippedWith;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (this.shouldFlipBean(method, tobeFlippedWith = (annotation = AnnotationUtils.getAnnotation(method, FlipBean.class)).with())) {
            Method targetMethod = this.getMethodOnTargetBean(method, tobeFlippedWith);
            logger.info("Flipping {} of {} with {} of {}", new Object[]{method.getName(), method.getDeclaringClass().getName(), targetMethod.getName(), targetMethod.getDeclaringClass().getName()});
            return this.invokeMethod(joinPoint, tobeFlippedWith, targetMethod);
        }
        return joinPoint.proceed();
    }

    private boolean shouldFlipBean(Method method, Class<?> tobeFlippedWith) {
        return this.flipAnnotationsStore.isFeatureEnabled(method) && tobeFlippedWith != method.getDeclaringClass();
    }

    private Method getMethodOnTargetBean(Method method, Class<?> tobeFlippedWith) {
        try {
            return ClassUtils.getMethod(tobeFlippedWith, (String)method.getName(), (Class[])method.getParameterTypes());
        }
        catch (IllegalStateException e) {
            throw new FlipBeanFailedException("Could not invoke " + method.getName() + " with parameters " + method.getParameterTypes() + " on class " + tobeFlippedWith, e);
        }
    }

    private Object invokeMethod(ProceedingJoinPoint joinPoint, Class<?> tobeFlippedWith, Method targetMethod) throws Throwable {
        try {
            return Utils.invokeMethod(targetMethod, this.applicationContext.getBean(tobeFlippedWith), joinPoint.getArgs());
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof FeatureNotEnabledException) {
                throw ex.getCause();
            }
            throw new FlipBeanFailedException(ex);
        }
    }
}

