/*
 * Decompiled with CFR 0.152.
 */
package org.flips.advice;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.flips.exception.FeatureNotEnabledException;
import org.flips.store.FlipAnnotationsStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class FlipFeatureAdvice {
    private FlipAnnotationsStore flipAnnotationsStore;

    @Autowired
    public FlipFeatureAdvice(@Lazy FlipAnnotationsStore flipAnnotationsStore) {
        this.flipAnnotationsStore = flipAnnotationsStore;
    }

    @Pointcut(value="execution(@(@org.flips.annotation.FlipOnOff *) * *(..)) && !@annotation(org.flips.annotation.FlipBean)")
    private void featureToInspectPointcut() {
    }

    @Before(value="featureToInspectPointcut()")
    public void inspectFlips(JoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        this.ensureFeatureIsEnabled(method);
    }

    private void ensureFeatureIsEnabled(Method method) {
        boolean featureEnabled = this.flipAnnotationsStore.isFeatureEnabled(method);
        if (!featureEnabled) {
            throw new FeatureNotEnabledException("Feature not enabled, identified by method " + method, method);
        }
    }
}

