/*
 * Decompiled with CFR 0.152.
 */
package org.flips.condition;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.flips.condition.FlipCondition;
import org.flips.model.FeatureContext;
import org.flips.model.FlipAnnotationAttributes;
import org.flips.utils.DateTimeUtils;
import org.flips.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DateTimeFlipCondition
implements FlipCondition {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeFlipCondition.class);

    @Override
    public boolean evaluateCondition(FeatureContext featureContext, FlipAnnotationAttributes flipAnnotationAttributes) {
        String dateTimeProperty = flipAnnotationAttributes.getAttributeValue("cutoffDateTimeProperty", "");
        ValidationUtils.requireNonEmpty(dateTimeProperty, "cutoffDateTimeProperty element can not be NULL or EMPTY when using @FlipOnDateTime");
        String dateTime = featureContext.getPropertyValueOrDefault(dateTimeProperty, String.class, "");
        ValidationUtils.requireNonEmpty(dateTime, dateTimeProperty + " containing datetime can not be NULL or EMPTY when using @FlipOnDateTime");
        return this.isCurrentDateTimeAfterOrEqualCutoffDateTime(this.getCutoffDateTime(dateTime), DateTimeUtils.getCurrentTime());
    }

    private boolean isCurrentDateTimeAfterOrEqualCutoffDateTime(ZonedDateTime cutoffDateTime, ZonedDateTime currentUtcTime) {
        logger.info("DateTimeFlipCondition: cutoffDateTime {}, currentUtcTime {}", (Object)cutoffDateTime, (Object)currentUtcTime);
        return currentUtcTime.isEqual(cutoffDateTime) || currentUtcTime.isAfter(cutoffDateTime);
    }

    private ZonedDateTime getCutoffDateTime(String datetime) {
        logger.info("DateTimeFlipCondition: parsing {}", (Object)datetime);
        try {
            return OffsetDateTime.parse(datetime).atZoneSameInstant(DateTimeUtils.UTC);
        }
        catch (DateTimeParseException e) {
            logger.error("Could not parse " + datetime + ", expected format yyyy-MM-ddTHH:mm:ssZ");
            throw e;
        }
    }
}

