/*
 * Decompiled with CFR 0.152.
 */
package org.flips.model;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flips.annotation.FlipOnOff;
import org.flips.condition.FlipCondition;
import org.flips.model.FeatureContext;
import org.flips.model.FlipAnnotationAttributes;
import org.flips.model.FlipConditionEvaluator;
import org.flips.utils.AnnotationUtils;
import org.flips.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

class DefaultFlipConditionEvaluator
extends FlipConditionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFlipConditionEvaluator.class);
    private Map<Class<? extends FlipCondition>, FlipAnnotationAttributes> flipConditions = new LinkedHashMap<Class<? extends FlipCondition>, FlipAnnotationAttributes>();

    protected DefaultFlipConditionEvaluator(ApplicationContext applicationContext, FeatureContext featureContext, Annotation[] annotations) {
        super(applicationContext, featureContext);
        ValidationUtils.requireNonNull(annotations, "annotations[] can not be null while constructing DefaultFlipConditionEvaluator");
        this.buildFlipConditions(annotations);
    }

    private void buildFlipConditions(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!AnnotationUtils.isMetaAnnotationDefined(annotation, FlipOnOff.class)) continue;
            Class<? extends FlipCondition> condition = AnnotationUtils.getAnnotationOfType(annotation, FlipOnOff.class).value();
            FlipAnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes(annotation);
            this.flipConditions.put(condition, annotationAttributes);
        }
        logger.debug("Built DefaultFlipConditionEvaluator {}", this.flipConditions);
    }

    private boolean evaluateFlipCondition(ApplicationContext applicationContext, FeatureContext featureContext, Class<? extends FlipCondition> conditionClazz, FlipAnnotationAttributes flipAnnotationAttributes) {
        return ((FlipCondition)applicationContext.getBean(conditionClazz)).evaluateCondition(featureContext, flipAnnotationAttributes);
    }

    @Override
    public boolean evaluate() {
        return this.flipConditions.entrySet().stream().map(entry -> this.evaluateFlipCondition(this.applicationContext, this.featureContext, (Class)entry.getKey(), (FlipAnnotationAttributes)entry.getValue())).filter(result -> result == Boolean.FALSE).findFirst().orElse(true);
    }

    @Override
    public boolean isEmpty() {
        return this.flipConditions.isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultFlipConditionEvaluator{");
        sb.append("flipConditions=").append(this.flipConditions);
        sb.append('}');
        return sb.toString();
    }
}

