/*
 * Decompiled with CFR 0.152.
 */
package org.flips.model;

import org.flips.model.FeatureExpressionContext;
import org.flips.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.stereotype.Component;

@Component
public class FeatureContext {
    private Environment environment;
    private FeatureExpressionContext featureExpressionContext;
    private static final Logger logger = LoggerFactory.getLogger(FeatureContext.class);

    @Autowired
    public FeatureContext(Environment environment, FeatureExpressionContext featureExpressionContext) {
        this.environment = environment;
        this.featureExpressionContext = featureExpressionContext;
    }

    public <T> T getPropertyValueOrDefault(String property, Class<T> t, T defaultValue) {
        logger.debug("Getting String property {}", (Object)property);
        return (T)this.environment.getProperty(property, t, defaultValue);
    }

    public String[] getActiveProfilesOrEmpty() {
        Object[] activeProfiles = this.environment.getActiveProfiles();
        logger.debug("Getting active profiles {}", activeProfiles);
        return Utils.isEmpty(activeProfiles) ? Utils.EMPTY_STRING_ARRAY : activeProfiles;
    }

    public ExpressionParser getExpressionParser() {
        return this.featureExpressionContext.getExpressionParser();
    }

    public EvaluationContext getEvaluationContext() {
        return this.featureExpressionContext.getEvaluationContext();
    }
}

