/*
 * Decompiled with CFR 0.152.
 */
package org.flips.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.flips.utils.ValidationUtils;

public class FlipAnnotationAttributes {
    private Map<String, Object> attributes = new HashMap<String, Object>();

    private FlipAnnotationAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    private Optional<Object> getAttributeValue(String attributeName) {
        ValidationUtils.requireNonEmpty(attributeName, "attributeName can not be NULL or EMPTY");
        return Optional.ofNullable(this.attributes.get(attributeName));
    }

    public <T> T getAttributeValue(String attributeName, T defaultValue) {
        return (T)this.getAttributeValue(attributeName).orElse(defaultValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlipAnnotationAttributes that = (FlipAnnotationAttributes)o;
        return this.attributes.equals(that.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FlipAnnotationAttributes{");
        sb.append("attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private Map<String, Object> attributes = new HashMap<String, Object>();

        public Builder addAll(Map<String, Object> newAttributes) {
            ValidationUtils.requireNonNull(newAttributes, "attributes to be added in FlipAnnotationAttributes can not be null");
            this.attributes.putAll(new HashMap<String, Object>(newAttributes));
            return this;
        }

        public FlipAnnotationAttributes build() {
            return new FlipAnnotationAttributes(this.attributes);
        }
    }
}

