/*
 * Decompiled with CFR 0.152.
 */
package org.flips.model;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.flips.model.DefaultFlipConditionEvaluator;
import org.flips.model.EmptyFlipConditionEvaluator;
import org.flips.model.FeatureContext;
import org.flips.model.FlipConditionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FlipConditionEvaluatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(FlipConditionEvaluatorFactory.class);
    private static FlipConditionEvaluator emptyFlipConditionEvaluator;
    private FeatureContext featureContext;
    private ApplicationContext applicationContext;

    @Autowired
    public FlipConditionEvaluatorFactory(ApplicationContext applicationContext, FeatureContext featureContext) {
        this.applicationContext = applicationContext;
        this.featureContext = featureContext;
    }

    @PostConstruct
    protected void buildEmptyFlipConditionEvaluator() {
        emptyFlipConditionEvaluator = new EmptyFlipConditionEvaluator(this.applicationContext, this.featureContext);
    }

    public FlipConditionEvaluator buildFlipConditionEvaluator(Annotation[] annotations) {
        logger.debug("Using FlipConditionEvaluatorFactory to build condition Evaluator for {}", (Object)Arrays.toString(annotations));
        if (annotations.length == 0) {
            return emptyFlipConditionEvaluator;
        }
        return new DefaultFlipConditionEvaluator(this.applicationContext, this.featureContext, annotations);
    }

    public FlipConditionEvaluator getEmptyFlipConditionEvaluator() {
        return emptyFlipConditionEvaluator;
    }
}

