/*
 * Decompiled with CFR 0.152.
 */
package org.flips.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.flips.model.FlipConditionEvaluator;
import org.flips.model.FlipConditionEvaluatorFactory;
import org.flips.utils.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlipAnnotationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FlipAnnotationProcessor.class);
    private FlipConditionEvaluatorFactory flipConditionEvaluatorFactory;

    @Autowired
    public FlipAnnotationProcessor(FlipConditionEvaluatorFactory flipConditionEvaluatorFactory) {
        this.flipConditionEvaluatorFactory = flipConditionEvaluatorFactory;
    }

    public FlipConditionEvaluator getFlipConditionEvaluator(Method method) {
        return this.getFlipConditionEvaluatorOnMethod(method);
    }

    private FlipConditionEvaluator getFlipConditionEvaluatorOnMethod(Method method) {
        logger.debug("Getting feature condition evaluator at Method level {}", (Object)method.getName());
        Annotation[] annotations = AnnotationUtils.getAnnotations(method);
        return this.buildFlipConditionEvaluator(annotations);
    }

    private FlipConditionEvaluator buildFlipConditionEvaluator(Annotation[] annotations) {
        return this.flipConditionEvaluatorFactory.buildFlipConditionEvaluator(annotations);
    }
}

