/*
 * Decompiled with CFR 0.152.
 */
package org.flips.store;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.flips.model.FlipConditionEvaluator;
import org.flips.model.FlipConditionEvaluatorFactory;
import org.flips.processor.FlipAnnotationProcessor;
import org.flips.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FlipAnnotationsStore {
    private static final Logger logger = LoggerFactory.getLogger(FlipAnnotationsStore.class);
    private final Map<Method, FlipConditionEvaluator> store = new HashMap<Method, FlipConditionEvaluator>();
    private final List<String> excludedPackages;
    private ApplicationContext applicationContext;
    private FlipAnnotationProcessor flipAnnotationProcessor;
    private FlipConditionEvaluatorFactory flipConditionEvaluatorFactory;

    @Autowired
    public FlipAnnotationsStore(ApplicationContext applicationContext, FlipAnnotationProcessor flipAnnotationProcessor, FlipConditionEvaluatorFactory flipConditionEvaluatorFactory, @Value(value="${exclude.package.scan}") String excludePackagesToScan) {
        this.applicationContext = applicationContext;
        this.flipAnnotationProcessor = flipAnnotationProcessor;
        this.flipConditionEvaluatorFactory = flipConditionEvaluatorFactory;
        this.excludedPackages = Arrays.asList(excludePackagesToScan.split(","));
    }

    @PostConstruct
    protected void buildFlipAnnotationsStore() {
        String[] flipComponents = this.getFlipComponents();
        if (flipComponents.length != 0) {
            Map<Method, FlipConditionEvaluator> flipConditionEvaluatorMap = Arrays.stream(flipComponents).flatMap(beanDefinition -> this.getAllMethodsWithConditionEvaluator(AopProxyUtils.ultimateTargetClass((Object)this.applicationContext.getBean(beanDefinition))).stream()).collect(Collectors.toMap(MethodConditionEvaluator::getMethod, MethodConditionEvaluator::getFlipConditionEvaluator));
            this.store.putAll(flipConditionEvaluatorMap);
        }
        logger.debug("Completed building FlipAnnotationsStore {}", this.store);
    }

    public boolean isFeatureEnabled(Method method) {
        return this.store.getOrDefault(method, this.flipConditionEvaluatorFactory.getEmptyFlipConditionEvaluator()).evaluate();
    }

    public int getTotalMethodsCached() {
        return this.store.size();
    }

    public Set<Method> allMethodsCached() {
        return new HashSet<Method>(this.store.keySet());
    }

    private List<MethodConditionEvaluator> getAllMethodsWithConditionEvaluator(Class<?> clazz) {
        if (!this.isPackageExcludedFromScan(clazz.getPackage().getName())) {
            logger.debug("Scanning class {} for flip annotations", (Object)clazz.getName());
            return Arrays.stream(clazz.getDeclaredMethods()).map(Utils::getAccessibleMethod).filter(accessibleMethod -> accessibleMethod != null).map(accessibleMethod -> new MethodConditionEvaluator((Method)accessibleMethod, this.flipAnnotationProcessor.getFlipConditionEvaluator((Method)accessibleMethod))).filter(methodConditionEvaluator -> !methodConditionEvaluator.getFlipConditionEvaluator().isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isPackageExcludedFromScan(String packageName) {
        return this.excludedPackages.stream().filter(excludedPackage -> packageName.startsWith((String)excludedPackage)).map(pkg -> true).findFirst().orElse(false);
    }

    private String[] getFlipComponents() {
        return this.applicationContext.getBeanDefinitionNames();
    }

    static class MethodConditionEvaluator {
        private Method method;
        private FlipConditionEvaluator flipConditionEvaluator;

        public MethodConditionEvaluator(Method method, FlipConditionEvaluator flipConditionEvaluator) {
            this.method = method;
            this.flipConditionEvaluator = flipConditionEvaluator;
        }

        public Method getMethod() {
            return this.method;
        }

        public FlipConditionEvaluator getFlipConditionEvaluator() {
            return this.flipConditionEvaluator;
        }
    }
}

