/*
 * Decompiled with CFR 0.152.
 */
package org.flips.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.flips.model.FlipAnnotationAttributes;

public final class AnnotationUtils {
    private AnnotationUtils() {
        throw new AssertionError((Object)"No AnnotationUtils instances for you!");
    }

    public static <T extends Annotation> T getAnnotationOfType(Annotation annotation, Class<T> cls) {
        return (T)org.springframework.core.annotation.AnnotationUtils.getAnnotation((Annotation)annotation, cls);
    }

    public static <T extends Annotation> T findAnnotationByTypeIfAny(Annotation[] annotations, Class<T> cls) {
        for (Annotation a : annotations) {
            T annotation = AnnotationUtils.getAnnotationOfType(a, cls);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static boolean isMetaAnnotationDefined(Annotation annotation, Class<? extends Annotation> annotationType) {
        return org.springframework.core.annotation.AnnotationUtils.isAnnotationMetaPresent(annotation.getClass(), annotationType);
    }

    public static Annotation[] getAnnotations(Method method) {
        return org.springframework.core.annotation.AnnotationUtils.getAnnotations((Method)method);
    }

    public static Annotation[] getAnnotations(Class<?> clazz) {
        return org.springframework.core.annotation.AnnotationUtils.getAnnotations(clazz);
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationType) {
        return method.getAnnotation(annotationType);
    }

    public static FlipAnnotationAttributes getAnnotationAttributes(Annotation annotation) {
        return new FlipAnnotationAttributes.Builder().addAll(org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)annotation)).build();
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationType) {
        return (T)org.springframework.core.annotation.AnnotationUtils.findAnnotation(clazz, annotationType);
    }
}

