/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import com.github.fge.jsonschema.messages.JsonReferenceErrors;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import java.net.URI;
import java.net.URISyntaxException;

public final class RefSanityChecks {
    private RefSanityChecks() {
    }

    public static JsonRef absoluteRef(String input) {
        URI uri;
        ProcessingMessage message = new ProcessingMessage();
        if (input == null) {
            throw new JsonReferenceError(message.message(JsonReferenceErrors.NULL_URI));
        }
        try {
            uri = new URI(input);
        }
        catch (URISyntaxException ignored) {
            throw new JsonReferenceError(message.message(JsonReferenceErrors.INVALID_URI).put("input", input));
        }
        JsonRef ref = JsonRef.fromURI(uri);
        if (!ref.isAbsolute()) {
            throw new JsonReferenceError(message.message(JsonReferenceErrors.REF_NOT_ABSOLUTE).put("input", ref));
        }
        return ref;
    }

    public static URI absoluteLocator(String input) {
        return RefSanityChecks.absoluteRef(input).getLocator();
    }
}

