/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;

public final class DraftV3TypeKeywordSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String ANY = "any";
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();

    public DraftV3TypeKeywordSyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, NodeType.ARRAY);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isTextual()) {
            if (!DraftV3TypeKeywordSyntaxChecker.typeIsValid(node.textValue())) {
                report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_PRIMITIVE_TYPE).put("valid", EnumSet.allOf(NodeType.class)).put("found", node));
            }
            return;
        }
        int size = node.size();
        HashSet set = Sets.newHashSet();
        boolean uniqueItems = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            uniqueItems = set.add(EQUIVALENCE.wrap((Object)element));
            if (type == NodeType.OBJECT) {
                pointers.add(JsonPointer.of(this.keyword, index));
                continue;
            }
            if (type != NodeType.STRING) {
                report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("index", index).put("expected", EnumSet.of(NodeType.OBJECT, NodeType.STRING)).put("found", type));
                continue;
            }
            if (DraftV3TypeKeywordSyntaxChecker.typeIsValid(element.textValue())) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_PRIMITIVE_TYPE).put("index", index).put("valid", EnumSet.allOf(NodeType.class)).put("found", element));
        }
        if (!uniqueItems) {
            report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
        }
    }

    private static boolean typeIsValid(String s) {
        if (ANY.equals(s)) {
            return true;
        }
        return NodeType.fromName(s) != null;
    }
}

