/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.LoadingConfiguration;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIManager;
import com.github.fge.jsonschema.messages.LoadingConfigurationMessages;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class SchemaLoader {
    private final URIManager manager;
    private final JsonRef namespace;
    private final LoadingCache<URI, JsonNode> cache;
    private final Dereferencing dereferencing;
    private final Map<URI, JsonNode> preloadedSchemas;

    public SchemaLoader(LoadingConfiguration cfg) {
        this.namespace = JsonRef.fromURI(cfg.getNamespace());
        this.dereferencing = cfg.getDereferencing();
        this.manager = new URIManager(cfg);
        this.preloadedSchemas = ImmutableMap.copyOf(cfg.getPreloadedSchemas());
        CacheBuilder cacheBuilder = cfg.getEnableCache() ? CacheBuilder.newBuilder() : CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.disableCaching());
        this.cache = cacheBuilder.build((CacheLoader)new CacheLoader<URI, JsonNode>(){

            public JsonNode load(URI key) throws ProcessingException {
                return SchemaLoader.this.manager.getContent(key);
            }
        });
    }

    public SchemaLoader() {
        this(LoadingConfiguration.byDefault());
    }

    public SchemaTree load(JsonNode schema) {
        if (schema == null) {
            throw new ProcessingError(new ProcessingMessage().message(LoadingConfigurationMessages.NULL_SCHEMA));
        }
        return this.dereferencing.newTree(schema);
    }

    public SchemaTree get(URI uri) throws ProcessingException {
        JsonRef ref = this.namespace.resolve(JsonRef.fromURI(uri));
        ProcessingMessage msg = new ProcessingMessage().put("uri", ref);
        if (!ref.isAbsolute()) {
            throw new ProcessingException(msg.message(RefProcessingMessages.URI_NOT_ABSOLUTE));
        }
        URI realURI = ref.toURI();
        try {
            JsonNode node = this.preloadedSchemas.get(realURI);
            if (node == null) {
                node = (JsonNode)this.cache.get((Object)realURI);
            }
            return this.dereferencing.newTree(ref, node);
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

