/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public final class URIManager {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final Map<String, URIDownloader> downloaders;
    private final ObjectMapper mapper;

    public URIManager() {
        this(LoadingConfiguration.byDefault());
    }

    public URIManager(LoadingConfiguration cfg) {
        this.downloaders = cfg.getDownloaderMap();
        this.mapper = cfg.getObjectMapper();
    }

    public JsonNode getContent(URI uri) throws ProcessingException {
        BUNDLE.checkNotNull((Object)uri, "jsonRef.nullURI");
        if (!uri.isAbsolute()) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotAbsolute")).put("uri", uri));
        }
        String scheme = uri.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.unhandledScheme")).putArgument("scheme", scheme).putArgument("uri", uri));
        }
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)downloader.fetch(uri));
            JsonParser parser = (JsonParser)closer.register((Closeable)this.mapper.getFactory().createParser(in));
            JsonNode jsonNode = this.readOneNode(in, parser, uri);
            return jsonNode;
        }
        catch (JsonMappingException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(e.getOriginalMessage()).put("uri", uri));
        }
        catch (JsonParseException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("uriManager.uriNotJson")).putArgument("uri", uri).put("parsingMessage", e.getOriginalMessage()));
        }
        catch (IOException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("uriManager.uriIOError")).putArgument("uri", uri).put("exceptionMessage", e.getMessage()));
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException ignored) {
                throw new IllegalStateException();
            }
        }
    }

    private JsonNode readOneNode(InputStream in, JsonParser parser, URI uri) throws IOException {
        MappingIterator iterator = this.mapper.readValues(parser, JsonNode.class);
        JsonLocation location = new JsonLocation((Object)in, 0L, 1, 1);
        String message = BUNDLE.printf("uriManager.noData", new Object[]{uri});
        if (!iterator.hasNextValue()) {
            throw new JsonMappingException(message, location);
        }
        JsonNode ret = (JsonNode)iterator.nextValue();
        location = parser.getCurrentLocation();
        message = BUNDLE.printf("uriManager.trailingData", new Object[]{uri});
        try {
            if (!iterator.hasNextValue()) {
                return ret;
            }
            throw new JsonMappingException(message, location);
        }
        catch (JsonParseException e) {
            throw new JsonMappingException(message, e.getLocation(), (Throwable)e);
        }
    }
}

