/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.examples.ExampleBase;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.uri.URIDownloader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public final class Example7
extends ExampleBase {
    public static void main(String ... args) throws IOException, JsonSchemaException {
        JsonNode good = Example7.loadResource("/fstab-good.json");
        JsonNode bad = Example7.loadResource("/fstab-bad.json");
        JsonNode bad2 = Example7.loadResource("/fstab-bad2.json");
        JsonSchemaFactory factory = JsonSchemaFactory.builder().registerScheme("foobar", CustomDownloader.getInstance()).build();
        JsonSchema schema = factory.fromURI("foobar:/fstab-draftv4.json#");
        ValidationReport report = schema.validate(good);
        Example7.printReport(report);
        report = schema.validate(bad);
        Example7.printReport(report);
        report = schema.validate(bad2);
        Example7.printReport(report);
    }

    private static final class CustomDownloader
    implements URIDownloader {
        private static final String PREFIX;
        private static final URIDownloader INSTANCE;

        private CustomDownloader() {
        }

        public static URIDownloader getInstance() {
            return INSTANCE;
        }

        @Override
        public InputStream fetch(URI source) throws IOException {
            String path = PREFIX + source.getPath();
            InputStream ret = this.getClass().getResourceAsStream(path);
            if (ret == null) {
                throw new IOException("resource " + path + " not found");
            }
            return ret;
        }

        static {
            INSTANCE = new CustomDownloader();
            String pkgname = CustomDownloader.class.getPackage().getName();
            PREFIX = '/' + pkgname.replace(".", "/");
        }
    }
}

