/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.hyperschema.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.CharMatchers;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public final class ContentEncodingSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new ContentEncodingSyntaxChecker();
    private static final Set<String> ENCODINGS = ImmutableSet.of((Object)"7bit", (Object)"8bit", (Object)"binary", (Object)"quoted-printable", (Object)"base64");

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private ContentEncodingSyntaxChecker() {
        super("contentEncoding", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        String protocol = value.toLowerCase();
        if (ENCODINGS.contains(protocol)) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("value", value);
        if (!protocol.startsWith("x-")) {
            msg.setMessage("illegal content encoding");
            messages.add(msg.build());
            return;
        }
        String s = protocol.substring(2);
        if (s.isEmpty()) {
            msg.setMessage("illegal content encoding: empty string after \"x-\"");
            messages.add(msg.build());
            return;
        }
        if (!CharMatchers.RFC2045_TOKEN.matchesAllOf((CharSequence)s)) {
            msg.setMessage("illegal content encoding: illegal token in custom content encoding");
            messages.add(msg.build());
        }
    }
}

