/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.github.fge.jsonschema.cfg.ValidationConfigurationBuilder;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.util.Frozen;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class ValidationConfiguration
implements Frozen<ValidationConfigurationBuilder> {
    final Map<JsonRef, Library> libraries;
    final Library defaultLibrary;
    final boolean useFormat;

    public static ValidationConfigurationBuilder newBuilder() {
        return new ValidationConfigurationBuilder();
    }

    public static ValidationConfiguration byDefault() {
        return ValidationConfiguration.newBuilder().freeze();
    }

    ValidationConfiguration(ValidationConfigurationBuilder cfg) {
        this.libraries = ImmutableMap.copyOf(cfg.libraries);
        this.defaultLibrary = cfg.defaultLibrary;
        this.useFormat = cfg.useFormat;
    }

    public Map<JsonRef, Library> getLibraries() {
        return this.libraries;
    }

    public Library getDefaultLibrary() {
        return this.defaultLibrary;
    }

    public boolean getUseFormat() {
        return this.useFormat;
    }

    public ValidationConfigurationBuilder thaw() {
        return new ValidationConfigurationBuilder(this);
    }
}

