/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.parse;

import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.expression.TemplateExpression;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.parse.TemplateParser;
import com.github.fge.uritemplate.parse.VariableSpecParser;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Map;

public final class ExpressionParser
implements TemplateParser {
    private static final Map<Character, ExpressionType> EXPRESSION_TYPE_MAP;
    private static final CharMatcher COMMA;
    private static final CharMatcher END_EXPRESSION;

    @Override
    public URITemplateExpression parse(CharBuffer buffer) throws URITemplateParseException {
        buffer.get();
        if (!buffer.hasRemaining()) {
            throw new URITemplateParseException("unexpected end of input: expected a comma or a closing bracket", buffer, true);
        }
        ExpressionType type = ExpressionType.SIMPLE;
        char c = buffer.charAt(0);
        if (EXPRESSION_TYPE_MAP.containsKey(Character.valueOf(c))) {
            type = EXPRESSION_TYPE_MAP.get(Character.valueOf(buffer.get()));
        }
        ArrayList varspecs = Lists.newArrayList();
        do {
            varspecs.add(VariableSpecParser.parse(buffer));
            if (buffer.hasRemaining()) continue;
            throw new URITemplateParseException("unexpected end of input: expected a comma or a closing bracket", buffer, true);
        } while (COMMA.matches(c = buffer.get()));
        if (!END_EXPRESSION.matches(c)) {
            throw new URITemplateParseException("unexpected token: expected a comma or a closing bracket", buffer, true);
        }
        return new TemplateExpression(type, varspecs);
    }

    static {
        COMMA = CharMatcher.is((char)',');
        END_EXPRESSION = CharMatcher.is((char)'}');
        ImmutableMap.Builder builder = ImmutableMap.builder();
        char c = '+';
        ExpressionType type = ExpressionType.RESERVED;
        builder.put((Object)Character.valueOf(c), (Object)type);
        c = '#';
        type = ExpressionType.FRAGMENT;
        builder.put((Object)Character.valueOf(c), (Object)type);
        c = '.';
        type = ExpressionType.NAME_LABELS;
        builder.put((Object)Character.valueOf(c), (Object)type);
        c = '/';
        type = ExpressionType.PATH_SEGMENTS;
        builder.put((Object)Character.valueOf(c), (Object)type);
        c = ';';
        type = ExpressionType.PATH_PARAMETERS;
        builder.put((Object)Character.valueOf(c), (Object)type);
        c = '?';
        type = ExpressionType.QUERY_STRING;
        builder.put((Object)Character.valueOf(c), (Object)type);
        c = '&';
        type = ExpressionType.QUERY_CONT;
        builder.put((Object)Character.valueOf(c), (Object)type);
        EXPRESSION_TYPE_MAP = builder.build();
    }
}

