/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.parse;

import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.expression.TemplateLiteral;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.parse.Matchers;
import com.github.fge.uritemplate.parse.TemplateParser;
import java.nio.CharBuffer;

public final class LiteralParser
implements TemplateParser {
    @Override
    public URITemplateExpression parse(CharBuffer buffer) throws URITemplateParseException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && Matchers.LITERALS.matches(c = buffer.charAt(0))) {
            sb.append(buffer.get());
            if (!Matchers.PERCENT.matches(c)) continue;
            LiteralParser.parsePercentEncoded(buffer, sb);
        }
        return new TemplateLiteral(sb.toString());
    }

    private static void parsePercentEncoded(CharBuffer buffer, StringBuilder sb) throws URITemplateParseException {
        if (buffer.remaining() < 2) {
            throw new URITemplateParseException("not enough remaining characters for a percent-encoded sequence", buffer, true);
        }
        char first = buffer.get();
        if (!Matchers.HEXDIGIT.matches(first)) {
            throw new URITemplateParseException("illegal character in percent-encoded sequence", buffer, true);
        }
        char second = buffer.get();
        if (!Matchers.HEXDIGIT.matches(second)) {
            throw new URITemplateParseException("illegal character in percent-encoded sequence", buffer, true);
        }
        sb.append(first).append(second);
    }
}

