/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.specs;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.specs.VariableSpecType;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SimpleVariable
extends VariableSpec {
    public SimpleVariable(String name) {
        super(VariableSpecType.SIMPLE, name);
    }

    @Override
    protected String renderScalar(ExpressionType type, String value) throws URITemplateException {
        String s = SimpleVariable.expandString(type, value);
        if (!PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(this.name);
        if (!s.isEmpty() || type != ExpressionType.PATH_PARAMETERS) {
            sb.append('=').append(s);
        }
        return sb.toString();
    }

    @Override
    protected String renderList(ExpressionType type, List<String> value) throws URITemplateException {
        if (value.isEmpty() && !PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return null;
        }
        Joiner joiner = Joiner.on((char)',');
        ArrayList list = Lists.newArrayList();
        for (String s : value) {
            list.add(SimpleVariable.expandString(type, s));
        }
        String joined = joiner.join((Iterable)list);
        if (!PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return joined;
        }
        StringBuilder sb = new StringBuilder(this.name);
        if (!joined.isEmpty() || type != ExpressionType.PATH_PARAMETERS) {
            sb.append('=').append(joined);
        }
        return sb.toString();
    }

    @Override
    protected String renderMap(ExpressionType type, Map<String, String> map) throws URITemplateException {
        if (map.isEmpty() && !PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return null;
        }
        Joiner joiner = Joiner.on((char)',');
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            list.add(SimpleVariable.expandString(type, entry.getKey()));
            list.add(SimpleVariable.expandString(type, entry.getValue()));
        }
        String joined = joiner.join((Iterable)list);
        if (!PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return joined;
        }
        StringBuilder sb = new StringBuilder(this.name);
        if (!joined.isEmpty() || type != ExpressionType.PATH_PARAMETERS) {
            sb.append('=').append(joined);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleVariable other = (SimpleVariable)obj;
        return this.name.equals(other.name);
    }

    @Override
    public String toString() {
        return this.name + " (simple)";
    }
}

