/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser.microarray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.Datum;
import smile.data.NumericAttribute;

public class PCLParser {
    public AttributeDataset parse(URI uri) throws IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String name, URI uri) throws IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public AttributeDataset parse(String path) throws IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(String name, String path) throws IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public AttributeDataset parse(File file) throws IOException, ParseException {
        return this.parse(file.getPath(), new FileInputStream(file));
    }

    public AttributeDataset parse(String name, File file) throws IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(String name, InputStream stream) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Empty data source.");
        }
        String[] tokens = line.split("\t", -1);
        int p = tokens.length - 3;
        line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature end of file.");
        }
        String[] weight = line.split("\t", -1);
        if (weight.length != tokens.length) {
            throw new IOException("Invalid sample weight header.");
        }
        Attribute[] attributes = new Attribute[p];
        for (int i = 0; i < p; ++i) {
            attributes[i] = new NumericAttribute(tokens[i + 3], null, (double)Double.valueOf(weight[i + 3]));
        }
        AttributeDataset data = new AttributeDataset(name, attributes);
        int i = 3;
        while ((line = reader.readLine()) != null) {
            tokens = line.split("\t", -1);
            if (tokens.length != weight.length) {
                throw new IOException(String.format("Invalid number of elements of line %d: %d", i, tokens.length));
            }
            double[] x = new double[p];
            for (int j = 0; j < p; ++j) {
                x[j] = tokens[j + 3].isEmpty() ? Double.NaN : Double.valueOf(tokens[j + 3]);
            }
            Datum<double[]> datum = new Datum<double[]>(x);
            datum.name = tokens[0];
            datum.description = tokens[1];
            datum.weight = Double.valueOf(tokens[2]);
            data.add(datum);
            ++i;
        }
        reader.close();
        return data;
    }
}

