/*
 * Decompiled with CFR 0.152.
 */
package com.inamik.text.tables;

import com.inamik.text.tables.Cell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class GridTable {
    private final int numRows;
    private final int numCols;
    private final Collection<String>[][] table;
    private final int[] colWidths;
    private final int[] rowHeights;
    private int tableWidth = 0;
    private int tableHeight = 0;

    public static GridTable of(int numRows, int numCols) {
        return new GridTable(numRows, numCols);
    }

    public GridTable(int numRows, int numCols) {
        if (numRows <= 0 || numCols <= 0) {
            throw new IllegalArgumentException();
        }
        this.numRows = numRows;
        this.numCols = numCols;
        this.table = new Collection[numRows][numCols];
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                this.table[r][c] = Cell.EMPTY;
            }
        }
        this.colWidths = new int[numCols];
        this.rowHeights = new int[numRows];
    }

    public GridTable put(int row, int col, Collection<String> cell) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("row");
        }
        if (col < 0 || col >= this.numCols) {
            throw new IndexOutOfBoundsException("col");
        }
        this._put(row, col, cell);
        this.updateRowRanges(row);
        this.updateColRanges(col);
        return this;
    }

    public GridTable apply(int row, int col, Cell.Function f) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("row");
        }
        if (col < 0 || col >= this.numCols) {
            throw new IndexOutOfBoundsException("col");
        }
        this._apply(row, col, f);
        this.updateRowRanges(row);
        this.updateColRanges(col);
        return this;
    }

    public GridTable apply(Cell.Function f) {
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                this._apply(row, col, f);
                this.updateColRanges(col);
            }
            this.updateRowRanges(row);
        }
        return this;
    }

    public GridTable applyToCol(int col, Cell.Function f) {
        if (col < 0 || col >= this.numCols) {
            throw new IndexOutOfBoundsException("col");
        }
        for (int row = 0; row < this.numRows; ++row) {
            this._apply(row, col, f);
            this.updateRowRanges(row);
        }
        this.updateColRanges(col);
        return this;
    }

    public GridTable applyToRow(int row, Cell.Function f) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("row");
        }
        for (int col = 0; col < this.numCols; ++col) {
            this._apply(row, col, f);
            this.updateColRanges(col);
        }
        this.updateRowRanges(row);
        return this;
    }

    public Collection<String> cell(int row, int col) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("row");
        }
        if (col < 0 || col >= this.numCols) {
            throw new IndexOutOfBoundsException("col");
        }
        return this._cell(row, col);
    }

    public int width() {
        return this.tableWidth;
    }

    public int height() {
        return this.tableHeight;
    }

    public int numRows() {
        return this.numRows;
    }

    public int numCols() {
        return this.numCols;
    }

    public int colWidth(int col) {
        if (col < 0 || col >= this.numCols) {
            throw new IndexOutOfBoundsException("col");
        }
        return this.colWidths[col];
    }

    public int rowHeight(int row) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("row");
        }
        return this.rowHeights[row];
    }

    public Collection<String> toCell() {
        ArrayList<String> cell = new ArrayList<String>(this.tableHeight);
        for (int row = 0; row < this.numRows; ++row) {
            int rowHeight = this.rowHeights[row];
            StringBuilder[] rowBuffers = new StringBuilder[rowHeight];
            for (int b = 0; b < rowHeight; ++b) {
                rowBuffers[b] = new StringBuilder();
            }
            for (int col = 0; col < this.numCols; ++col) {
                Iterator<String> cellLines = this._cell(row, col).iterator();
                for (StringBuilder buffer : rowBuffers) {
                    if (!cellLines.hasNext()) continue;
                    buffer.append(cellLines.next());
                }
            }
            for (StringBuilder b : rowBuffers) {
                cell.add(b.toString());
            }
        }
        return Collections.unmodifiableCollection(cell);
    }

    private void updateRowRanges(int row) {
        int height = 0;
        for (int col = 0; col < this.numCols; ++col) {
            height = Math.max(height, this.table[row][col].size());
        }
        int oldHeight = this.rowHeights[row];
        this.rowHeights[row] = height;
        this.tableHeight = this.tableHeight - oldHeight + height;
    }

    private void updateColRanges(int col) {
        int width = 0;
        for (int row = 0; row < this.numRows; ++row) {
            for (String line : this.table[row][col]) {
                width = Math.max(width, line.length());
            }
        }
        int oldWidth = this.colWidths[col];
        this.colWidths[col] = width;
        this.tableWidth = this.tableWidth - oldWidth + width;
    }

    private void _put(int row, int col, Collection<String> cell) {
        this.table[row][col] = Collections.unmodifiableCollection(cell);
    }

    private void _apply(int row, int col, Cell.Function f) {
        this._put(row, col, f.apply(this.colWidths[col], this.rowHeights[row], this.table[row][col]));
    }

    private Collection<String> _cell(int row, int col) {
        return this.table[row][col];
    }
}

