/*
 * Decompiled with CFR 0.152.
 */
package com.inamik.text.tables;

import com.inamik.text.tables.Cell;
import com.inamik.text.tables.GridTable;
import com.inamik.text.tables.cell.base.Function;
import java.util.Collection;
import java.util.LinkedList;

public class SimpleTable {
    private LinkedList<LinkedList<Collection<String>>> table = new LinkedList();
    private int numRows = 0;
    private int numCols = 0;

    public static SimpleTable of() {
        return new SimpleTable();
    }

    public SimpleTable nextRow() {
        LinkedList row = new LinkedList();
        this.table.add(row);
        ++this.numRows;
        return this;
    }

    public SimpleTable nextCell() {
        if (this.table.isEmpty()) {
            throw new IllegalStateException("Table is empty. Call nextRow() first");
        }
        LinkedList<Collection<String>> row = this.table.getLast();
        row.add(Cell.EMPTY);
        this.numCols = Math.max(this.numCols, row.size());
        return this;
    }

    public SimpleTable nextCell(String ... lines) {
        return this.nextCell().addLines(lines);
    }

    public SimpleTable nextCell(Collection<String> lines) {
        return this.nextCell().addLines(lines);
    }

    public SimpleTable addLine(String line) {
        if (this.table.isEmpty()) {
            throw new IllegalStateException("Table is empty. Call nextRow() first");
        }
        LinkedList<Collection<String>> row = this.table.getLast();
        if (row.isEmpty()) {
            throw new IllegalStateException("Row is empty.  Call nextCell() first");
        }
        Collection<String> cell = row.removeLast();
        cell = Cell.append(cell, line);
        row.add(cell);
        return this;
    }

    public SimpleTable addLines(String ... lines) {
        if (this.table.isEmpty()) {
            throw new IllegalStateException("Table is empty. Call nextRow() first");
        }
        LinkedList<Collection<String>> row = this.table.getLast();
        if (row.isEmpty()) {
            throw new IllegalStateException("Row is empty.  Call nextCell() first");
        }
        Collection<String> cell = row.removeLast();
        cell = Cell.append(cell, lines);
        row.add(cell);
        return this;
    }

    public SimpleTable addLines(Collection<String> lines) {
        if (this.table.isEmpty()) {
            throw new IllegalStateException("Table is empty. Call nextRow() first");
        }
        LinkedList<Collection<String>> row = this.table.getLast();
        if (row.isEmpty()) {
            throw new IllegalStateException("Row is empty.  Call nextCell() first");
        }
        Collection<String> cell = row.removeLast();
        cell = Cell.append(cell, lines);
        row.add(cell);
        return this;
    }

    public SimpleTable applyToCell(Function f) {
        if (this.table.isEmpty()) {
            throw new IllegalStateException("Table is empty. Call nextRow() first");
        }
        LinkedList<Collection<String>> row = this.table.getLast();
        if (row.isEmpty()) {
            throw new IllegalStateException("Row is empty.  Call nextCell() first");
        }
        Collection<String> cell = row.removeLast();
        cell = f.apply(cell);
        row.add(cell);
        return this;
    }

    public SimpleTable applyToCell(Cell.Function f) {
        if (this.table.isEmpty()) {
            throw new IllegalStateException("Table is empty. Call nextRow() first");
        }
        LinkedList<Collection<String>> row = this.table.getLast();
        if (row.isEmpty()) {
            throw new IllegalStateException("Row is empty.  Call nextCell() first");
        }
        Collection<String> cell = row.removeLast();
        cell = f.apply(cell);
        row.add(cell);
        return this;
    }

    public int nextRowNum() {
        return this.table.size();
    }

    public int nextColNum() {
        return this.table.isEmpty() ? 0 : this.table.getLast().size();
    }

    public int numRows() {
        return this.numRows;
    }

    public int numCols() {
        return this.numCols;
    }

    public GridTable toGrid() {
        GridTable grid = GridTable.of(this.numRows, this.numCols);
        int rowNum = 0;
        for (LinkedList linkedList : this.table) {
            int colNum = 0;
            for (Collection cell : linkedList) {
                grid.put(rowNum, colNum, cell);
                ++colNum;
            }
            ++rowNum;
        }
        return grid;
    }
}

