/*
 * Decompiled with CFR 0.152.
 */
package com.inamik.text.tables.cell.base;

import com.inamik.text.tables.cell.base.FunctionWithChar;
import com.inamik.text.tables.cell.base.FunctionWithWidth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class FunctionWithCharAndWidth {
    public static final FunctionWithCharAndWidth IDENTITY = new FunctionWithCharAndWidth(){

        @Override
        public FunctionWithWidth withChar(char _1) {
            return FunctionWithWidth.IDENTITY;
        }

        @Override
        public FunctionWithChar withWidth(int _1) {
            return FunctionWithChar.IDENTITY;
        }

        @Override
        public Collection<String> apply(Character _1, Integer _2, Collection<String> cell) {
            return cell;
        }
    };

    public abstract Collection<String> apply(Character var1, Integer var2, Collection<String> var3);

    public static FunctionWithCharAndWidth from(final com.inamik.text.tables.line.base.FunctionWithCharAndWidth f) {
        return new FunctionWithCharAndWidth(){

            @Override
            public FunctionWithWidth withChar(char character) {
                return FunctionWithWidth.from(f.withChar(character));
            }

            @Override
            public FunctionWithChar withWidth(int width) {
                return FunctionWithChar.from(f.withWidth(width));
            }

            @Override
            public Collection<String> apply(Character character, Integer width, Collection<String> cell) {
                ArrayList<String> r = new ArrayList<String>(cell.size());
                for (String line : cell) {
                    r.add(f.apply(character, width, line));
                }
                return Collections.unmodifiableCollection(r);
            }
        };
    }

    public FunctionWithWidth withChar(final char character) {
        final FunctionWithCharAndWidth f = this;
        return new FunctionWithWidth(){

            @Override
            public Collection<String> apply(Integer width, Collection<String> cell) {
                return f.apply(Character.valueOf(character), width, cell);
            }
        };
    }

    public FunctionWithChar withWidth(final int width) {
        final FunctionWithCharAndWidth f = this;
        return new FunctionWithChar(){

            @Override
            public Collection<String> apply(Character character, Collection<String> cell) {
                return f.apply(character, width, cell);
            }
        };
    }
}

