/*
 * Decompiled with CFR 0.152.
 */
package com.inamik.text.tables.cell.base;

import com.inamik.text.tables.cell.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class FunctionWithWidth {
    public static final FunctionWithWidth IDENTITY = new FunctionWithWidth(){

        @Override
        public Function withWidth(int _1) {
            return Function.IDENTITY;
        }

        @Override
        public Collection<String> apply(Integer height, Collection<String> cell) {
            return cell;
        }
    };

    public abstract Collection<String> apply(Integer var1, Collection<String> var2);

    public static FunctionWithWidth from(final com.inamik.text.tables.line.base.FunctionWithWidth f) {
        return new FunctionWithWidth(){

            @Override
            public Function withWidth(int width) {
                return Function.from(f.withWidth(width));
            }

            @Override
            public Collection<String> apply(Integer width, Collection<String> cell) {
                ArrayList<String> r = new ArrayList<String>(cell.size());
                for (String line : cell) {
                    r.add(f.apply(width, line));
                }
                return Collections.unmodifiableCollection(r);
            }
        };
    }

    public Function withWidth(final int width) {
        final FunctionWithWidth f = this;
        return new Function(){

            @Override
            public Collection<String> apply(Collection<String> cell) {
                return f.apply(width, cell);
            }
        };
    }
}

