/*
 * Decompiled with CFR 0.152.
 */
package com.inamik.text.tables.grid;

import com.inamik.text.tables.Cell;
import com.inamik.text.tables.GridTable;
import java.util.ArrayList;
import java.util.Collection;

public final class Border {
    public static final Border DOUBLE_LINE = Border.of(Chars.DOUBLE_LINE);
    public static final Border SINGLE_LINE = Border.of(Chars.SINGLE_LINE);
    private final Chars chars;

    public static Border of(Chars chars) {
        return new Border(chars);
    }

    public Border(Chars chars) {
        this.chars = chars;
    }

    public GridTable apply(GridTable grid) {
        int h;
        int c;
        int r;
        int gr = grid.numRows();
        int gc = grid.numCols();
        GridTable b = GridTable.of(gr * 2 + 1, gc * 2 + 1);
        for (r = 0; r < gr; ++r) {
            for (c = 0; c < gc; ++c) {
                b.put(r * 2 + 1, c * 2 + 1, grid.cell(r, c));
            }
        }
        r = 0;
        c = 0;
        b.put(r, c, Cell.of(String.valueOf(this.chars.topLeft)));
        ++c;
        for (h = 0; h < gc; ++h) {
            b.put(r, c, this.hline(grid.colWidth(h)));
            ++c;
            if (h >= gc - 1) continue;
            b.put(r, c, Cell.of(String.valueOf(this.chars.topIntersect)));
            ++c;
        }
        b.put(r, c, Cell.of(String.valueOf(this.chars.topRight)));
        ++c;
        for (int v = 0; v < gr; ++v) {
            int h2;
            c = 0;
            b.put(++r, c, this.vline(grid.rowHeight(v)));
            ++c;
            for (h2 = 0; h2 < gc; ++h2) {
                ++c;
                if (h2 >= gc - 1) continue;
                b.put(r, c, this.vline(grid.rowHeight(v)));
                ++c;
            }
            b.put(r, c, this.vline(grid.rowHeight(v)));
            ++c;
            if (v >= gr - 1) continue;
            c = 0;
            b.put(++r, c, Cell.of(String.valueOf(this.chars.LeftIntersect)));
            ++c;
            for (h2 = 0; h2 < gc; ++h2) {
                b.put(r, c, this.hline(grid.colWidth(h2)));
                ++c;
                if (h2 >= gc - 1) continue;
                b.put(r, c, Cell.of(String.valueOf(this.chars.intersect)));
                ++c;
            }
            b.put(r, c, Cell.of(String.valueOf(this.chars.RightIntersect)));
            ++c;
        }
        c = 0;
        b.put(++r, c, Cell.of(String.valueOf(this.chars.bottomLeft)));
        ++c;
        for (h = 0; h < gc; ++h) {
            b.put(r, c, this.hline(grid.colWidth(h)));
            ++c;
            if (h >= gc - 1) continue;
            b.put(r, c, Cell.of(String.valueOf(this.chars.bottomIntersect)));
            ++c;
        }
        b.put(r, c, Cell.of(String.valueOf(this.chars.bottomRight)));
        ++c;
        return b;
    }

    private Collection<String> hline(int width) {
        StringBuilder sb = new StringBuilder(width);
        while (sb.length() < width) {
            sb.append(this.chars.horizontal);
        }
        return Cell.of(sb.toString());
    }

    private Collection<String> vline(int height) {
        ArrayList<String> newLines = new ArrayList<String>(height);
        String line = Character.toString(this.chars.vertical);
        while (newLines.size() < height) {
            newLines.add(line);
        }
        return newLines;
    }

    public static class Chars {
        public static final Chars DOUBLE_LINE = new Chars('\u256c', '\u2550', '\u2551', '\u2554', '\u2566', '\u2557', '\u2560', '\u2563', '\u255a', '\u2569', '\u255d');
        public static final Chars SINGLE_LINE = new Chars('\u253c', '\u2500', '\u2502', '\u250c', '\u252c', '\u2510', '\u251c', '\u2524', '\u2514', '\u2534', '\u2518');
        public final char intersect;
        public final char horizontal;
        public final char vertical;
        public final char topLeft;
        public final char topIntersect;
        public final char topRight;
        public final char LeftIntersect;
        public final char RightIntersect;
        public final char bottomLeft;
        public final char bottomIntersect;
        public final char bottomRight;

        public static Chars of(char intersect) {
            return new Chars(intersect, intersect, intersect, intersect, intersect, intersect, intersect, intersect, intersect, intersect, intersect);
        }

        public static Chars of(char intersect, char horizontal, char vertical) {
            return new Chars(intersect, horizontal, vertical, intersect, intersect, intersect, intersect, intersect, intersect, intersect, intersect);
        }

        public Chars(char i, char h, char v, char tl, char ti, char tr, char li, char ri, char bl, char bi, char br) {
            this.intersect = i;
            this.horizontal = h;
            this.vertical = v;
            this.topLeft = tl;
            this.topIntersect = ti;
            this.topRight = tr;
            this.LeftIntersect = li;
            this.RightIntersect = ri;
            this.bottomLeft = bl;
            this.bottomIntersect = bi;
            this.bottomRight = br;
        }
    }
}

