/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet.section;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ISectionBuilder;

public class SystemSection
implements ISectionBuilder {
    private final DocItemBuilder diBuilder;

    public SystemSection(DocItemBuilder diBuilder) {
        this.diBuilder = diBuilder;
    }

    @Override
    public DocSection section() {
        DocSection section = new DocSection("System", "system");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection venice = new DocSection("Venice", "system.venice");
        all.addSection(venice);
        venice.addItem(this.diBuilder.getDocItem("version"));
        DocSection system = new DocSection("System", "system.system");
        all.addSection(system);
        system.addItem(this.diBuilder.getDocItem("system-prop"));
        system.addItem(this.diBuilder.getDocItem("system-env"));
        system.addItem(this.diBuilder.getDocItem("system-exit-code"));
        system.addItem(this.diBuilder.getDocItem("charset-default-encoding"));
        DocSection java = new DocSection("Java", "system.java");
        all.addSection(java);
        java.addItem(this.diBuilder.getDocItem("java-version"));
        java.addItem(this.diBuilder.getDocItem("java-version-info"));
        java.addItem(this.diBuilder.getDocItem("java-major-version"));
        java.addItem(this.diBuilder.getDocItem("java-source-location", false));
        DocSection javaVM = new DocSection("Java VM", "system.java-vm");
        all.addSection(javaVM);
        javaVM.addItem(this.diBuilder.getDocItem("pid"));
        javaVM.addItem(this.diBuilder.getDocItem("gc"));
        javaVM.addItem(this.diBuilder.getDocItem("total-memory"));
        javaVM.addItem(this.diBuilder.getDocItem("used-memory"));
        DocSection os = new DocSection("OS", "system.os");
        all.addSection(os);
        os.addItem(this.diBuilder.getDocItem("os-type"));
        os.addItem(this.diBuilder.getDocItem("os-type?"));
        os.addItem(this.diBuilder.getDocItem("os-arch"));
        os.addItem(this.diBuilder.getDocItem("os-name"));
        os.addItem(this.diBuilder.getDocItem("os-version"));
        DocSection time = new DocSection("Time", "system.time");
        all.addSection(time);
        time.addItem(this.diBuilder.getDocItem("current-time-millis"));
        time.addItem(this.diBuilder.getDocItem("nano-time"));
        time.addItem(this.diBuilder.getDocItem("format-nano-time"));
        time.addItem(this.diBuilder.getDocItem("format-micro-time"));
        time.addItem(this.diBuilder.getDocItem("format-milli-time"));
        DocSection host = new DocSection("Host", "system.host");
        all.addSection(host);
        host.addItem(this.diBuilder.getDocItem("host-name"));
        host.addItem(this.diBuilder.getDocItem("host-address"));
        host.addItem(this.diBuilder.getDocItem("ip-private?"));
        host.addItem(this.diBuilder.getDocItem("cpus"));
        DocSection user = new DocSection("User", "system.user");
        all.addSection(user);
        user.addItem(this.diBuilder.getDocItem("user-name"));
        user.addItem(this.diBuilder.getDocItem("io/user-home-dir"));
        DocSection util = new DocSection("Util", "system.util");
        all.addSection(util);
        util.addItem(this.diBuilder.getDocItem("uuid"));
        util.addItem(this.diBuilder.getDocItem("sleep"));
        util.addItem(this.diBuilder.getDocItem("shutdown-hook"));
        DocSection shell = new DocSection("Shell", "system.shell");
        all.addSection(shell);
        shell.addItem(this.diBuilder.getDocItem("sh", false));
        shell.addItem(this.diBuilder.getDocItem("with-sh-dir", false));
        shell.addItem(this.diBuilder.getDocItem("with-sh-env", false));
        shell.addItem(this.diBuilder.getDocItem("with-sh-throw", false));
        DocSection tools = new DocSection("Shell Tools", "system.shell.tools");
        all.addSection(tools);
        tools.addItem(this.diBuilder.getDocItem("sh/open", false));
        tools.addItem(this.diBuilder.getDocItem("sh/pwd", false));
        return section;
    }

    private String id() {
        return this.diBuilder.id();
    }
}

