/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.namespaces;

import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.types.VncSymbol;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NamespaceRegistry
implements Serializable {
    private static final long serialVersionUID = 672571759583276084L;
    private final Map<VncSymbol, Namespace> namespaces = new ConcurrentHashMap<VncSymbol, Namespace>();

    public void add(Namespace ns) {
        Objects.requireNonNull(ns);
        this.namespaces.put(ns.getNS(), ns);
    }

    public void add(NamespaceRegistry nsRegistry) {
        for (Namespace ns : nsRegistry.namespaces.values()) {
            this.add(ns);
        }
    }

    public Namespace get(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.get(sym);
    }

    public Namespace computeIfAbsent(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.computeIfAbsent(sym, s -> new Namespace((VncSymbol)s));
    }

    public Namespace remove(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.remove(sym);
    }

    public void clear() {
        this.namespaces.clear();
    }
}

