/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Map;

public class VncThreadLocal
extends VncVal {
    public static final String TYPE = ":core/thread-local";
    private static final long serialVersionUID = -1848883965231344442L;

    public VncThreadLocal() {
        super(Constants.Nil);
    }

    public VncThreadLocal(Map<VncVal, VncVal> val) {
        super(Constants.Nil);
        val.entrySet().forEach(e -> this.set(Coerce.toVncKeyword((VncVal)e.getKey()), (VncVal)e.getValue()));
    }

    public VncThreadLocal(VncList lst) {
        super(Constants.Nil);
        this.assoc(lst);
    }

    @Override
    public VncThreadLocal withMeta(VncVal meta) {
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/val")));
    }

    public VncVal get(VncKeyword key) {
        return ThreadContext.getValue(key);
    }

    public VncVal get(VncKeyword key, VncVal defaultValue) {
        return ThreadContext.getValue(key, defaultValue);
    }

    public VncVal get(String key) {
        return this.get(new VncKeyword(key));
    }

    public VncVal get(String key, VncVal defaultValue) {
        return this.get(new VncKeyword(key), defaultValue);
    }

    public void set(VncKeyword key, VncVal val) {
        ThreadContext.setValue(key, val);
    }

    public void remove(VncKeyword key) {
        ThreadContext.removeValue(key);
    }

    public VncVal containsKey(VncKeyword key) {
        return VncBoolean.of(key != null && ThreadContext.containsKey(key));
    }

    public VncThreadLocal assoc(VncVal ... kvs) {
        for (int ii = 0; ii < kvs.length - 1; ii += 2) {
            VncKeyword key = Coerce.toVncKeyword(kvs[ii]);
            if (VncThreadLocal.isSystemKey(key)) {
                throw new VncException(String.format("The %s value must be added/modifed on the thread local vars!", key));
            }
            this.set(key, kvs[ii + 1]);
        }
        return this;
    }

    public VncThreadLocal assoc(VncList mvs) {
        VncList kv = mvs;
        while (!kv.isEmpty()) {
            VncKeyword key = Coerce.toVncKeyword(kv.first());
            if (VncThreadLocal.isSystemKey(key)) {
                throw new VncException(String.format("The %s value must be added/modifed on the thread local vars!", key));
            }
            this.set(key, kv.second());
            kv = kv.drop(2);
        }
        return this;
    }

    public VncThreadLocal dissoc(VncList lst) {
        for (VncVal v : lst) {
            VncKeyword key = Coerce.toVncKeyword(v);
            if (VncThreadLocal.isSystemKey(key)) {
                throw new VncException(String.format("The %s value must be removed from the thread local vars!", key));
            }
            this.remove(key);
        }
        return this;
    }

    public VncThreadLocal dissoc(VncKeyword ... ks) {
        for (int ii = 0; ii < ks.length; ++ii) {
            if (VncThreadLocal.isSystemKey(ks[ii])) {
                throw new VncException(String.format("The %s value must be removed from the thread local vars!", ks[ii]));
            }
            this.remove(ks[ii]);
        }
        return this;
    }

    public VncThreadLocal clear(boolean preserveSystemValues) {
        ThreadContext.clearValues(preserveSystemValues);
        return this;
    }

    public static VncMap toMap() {
        return new VncHashMap(ThreadContext.getValues()).dissoc(new VncKeyword("*in*")).dissoc(new VncKeyword("*out*")).dissoc(new VncKeyword("*err*"));
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.THREADLOCAL;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return "ThreadLocal";
    }

    private static boolean isSystemKey(VncKeyword key) {
        return "*in*".equals(key.getSimpleName()) || "*out*".equals(key.getSimpleName()) || "*err*".equals(key.getSimpleName());
    }
}

