/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobclient;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.failstore.FailStorePathBuilder;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.support.RetryScheduler;
import com.github.ltsopensource.jobclient.JobClient;
import com.github.ltsopensource.jobclient.domain.JobClientAppContext;
import com.github.ltsopensource.jobclient.domain.JobClientNode;
import com.github.ltsopensource.jobclient.domain.Response;
import com.github.ltsopensource.jobclient.support.JobSubmitProtectException;
import java.util.Collections;
import java.util.List;

public class RetryJobClient
extends JobClient<JobClientNode, JobClientAppContext> {
    private RetryScheduler<Job> jobRetryScheduler;

    @Override
    protected void beforeStart() {
        super.beforeStart();
        this.jobRetryScheduler = new RetryScheduler<Job>(RetryJobClient.class.getSimpleName(), this.appContext, FailStorePathBuilder.getJobSubmitFailStorePath((AppContext)this.appContext), 10){

            protected boolean isRemotingEnable() {
                return RetryJobClient.this.isServerEnable();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean retry(List<Job> jobs) {
                Response response = null;
                try {
                    response = RetryJobClient.this.superSubmitJob(jobs, JobClient.SubmitType.SYNC);
                    boolean bl = response.isSuccess();
                    return bl;
                }
                catch (Throwable t) {
                    RetryScheduler.LOGGER.error(t.getMessage(), t);
                }
                finally {
                    if (response != null && response.isSuccess()) {
                        RetryJobClient.this.stat.incSubmitFailStoreNum(jobs.size());
                    }
                }
                return false;
            }
        };
        this.jobRetryScheduler.start();
    }

    @Override
    protected void beforeStop() {
        super.beforeStop();
        this.jobRetryScheduler.stop();
    }

    @Override
    public Response submitJob(Job job) {
        return this.submitJob(Collections.singletonList(job));
    }

    @Override
    public Response submitJob(List<Job> jobs) {
        Response response;
        try {
            response = this.superSubmitJob(jobs);
        }
        catch (JobSubmitProtectException e) {
            response = new Response();
            response.setSuccess(false);
            response.setFailedJobs(jobs);
            response.setCode("14");
            response.setMsg(response.getMsg() + ", submit too busy");
        }
        if (!response.isSuccess()) {
            try {
                for (Job job : response.getFailedJobs()) {
                    this.jobRetryScheduler.inSchedule(job.getTaskId(), (Object)job);
                    this.stat.incFailStoreNum();
                }
                response.setSuccess(true);
                response.setCode("12");
                response.setMsg(response.getMsg() + ", save local fail store and send later !");
                LOGGER.warn(JSON.toJSONString((Object)response));
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setMsg(e.getMessage());
            }
        }
        return response;
    }

    private Response superSubmitJob(List<Job> jobs) {
        return super.submitJob(jobs);
    }

    private Response superSubmitJob(List<Job> jobs, JobClient.SubmitType type) {
        return super.submitJob(jobs, type);
    }
}

