/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.MemoryFileLock;
import java.io.IOException;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

final class LockSet {
    private final NavigableMap<Long, MemoryFileLock> locks = new TreeMap<Long, MemoryFileLock>();

    LockSet() {
    }

    MemoryFileLock tryLock(MemoryFileLock lock) {
        return this.tryPut(lock);
    }

    private MemoryFileLock tryPut(MemoryFileLock lock) {
        Map.Entry<Long, MemoryFileLock> ceilingEntry = this.locks.ceilingEntry(lock.position());
        Map.Entry<Long, MemoryFileLock> floorEntry = this.locks.floorEntry(lock.position());
        if (ceilingEntry != null && ceilingEntry.getValue().overlaps(lock.position(), lock.size())) {
            return null;
        }
        if (floorEntry != null && floorEntry.getValue().overlaps(lock.position(), lock.size())) {
            return null;
        }
        this.locks.put(lock.position(), lock);
        return lock;
    }

    MemoryFileLock lock(MemoryFileLock lock) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new FileLockInterruptionException();
        }
        MemoryFileLock returnValue = this.tryLock(lock);
        if (returnValue == null) {
            throw new OverlappingFileLockException();
        }
        return returnValue;
    }

    void remove(MemoryFileLock lock) {
        this.locks.remove(lock.position());
        lock.invalidate();
    }
}

