/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.properties.Base64Encoder;
import uk.co.mruoc.properties.FileContentLoader;

public class Base64FileContentLoader
implements FileContentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64FileContentLoader.class);
    private final Base64Encoder base64Encoder = new Base64Encoder();
    private final FileContentLoader contentLoader;

    public Base64FileContentLoader(FileContentLoader contentLoader) {
        this.contentLoader = contentLoader;
    }

    @Override
    public String loadContent(String path) {
        String content = this.contentLoader.loadContent(path);
        String base64 = this.base64Encoder.encode(content);
        LOGGER.info("converted content " + content + " into base64 " + base64);
        return base64;
    }
}

