/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.properties;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.properties.FileContentLoadException;
import uk.co.mruoc.properties.FileContentLoader;
import uk.co.mruoc.properties.InputStreamConverter;

public class ClasspathFileContentLoader
implements FileContentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathFileContentLoader.class);
    private InputStreamConverter converter = new InputStreamConverter();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String loadContent(String path) {
        LOGGER.info("loading file content from classpath using path " + path);
        try (InputStream stream = this.getClass().getResourceAsStream(path);){
            String string = this.converter.toString(stream);
            return string;
        }
        catch (IOException | NullPointerException e) {
            throw new FileContentLoadException(path, e);
        }
    }
}

