/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.properties.InputStreamConverter;
import uk.co.mruoc.properties.PropertiesNotFoundException;
import uk.co.mruoc.properties.PropertyLoader;

public class ClasspathPropertyLoader
implements PropertyLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathPropertyLoader.class);
    private InputStreamConverter converter = new InputStreamConverter();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties load(String path) {
        LOGGER.info("loading properties from classpath using path " + path);
        try (InputStream stream = this.getClass().getResourceAsStream(path);){
            Properties properties = this.converter.toProperties(stream);
            return properties;
        }
        catch (IOException | NullPointerException e) {
            throw new PropertiesNotFoundException(path, e);
        }
    }
}

